-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jun 13, 2025 at 05:33 PM
-- Server version: 8.0.33
-- PHP Version: 8.2.28

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `zerp`
--

-- --------------------------------------------------------

--
-- Table structure for table `account_accounts`
--

CREATE TABLE `account_accounts` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint UNSIGNED DEFAULT NULL,
  `accounts_level` enum('Account Types','Account Head','Account Groups','Account Ledgers') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Account Ledgers',
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `account_periods`
--

CREATE TABLE `account_periods` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `open_status` enum('Void','Open','Close') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Void',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `account_sub_ledger`
--

CREATE TABLE `account_sub_ledger` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `accounts_id` bigint UNSIGNED NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `account_transactions`
--

CREATE TABLE `account_transactions` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posting_date` date NOT NULL,
  `account_period_id` bigint UNSIGNED NOT NULL,
  `voucher_type` enum('Opening Balance','Closing Balance','Journal Voucher','Sales Voucher','Sales Return','Purchase Voucher','Purchase Return','Payment Voucher','Receive Voucher','Expense Voucher','Contra Voucher') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Journal Voucher',
  `business_units_id` bigint UNSIGNED NOT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `account_transactions_lines`
--

CREATE TABLE `account_transactions_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `account_transactions_id` bigint UNSIGNED NOT NULL,
  `posting_date` date NOT NULL,
  `account_period_id` bigint UNSIGNED NOT NULL,
  `accounts_id` bigint UNSIGNED NOT NULL,
  `sub_ledger_id` bigint UNSIGNED DEFAULT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `voucher_type` enum('Opening Balance','Closing Balance','Journal Voucher','Sales Voucher','Sales Return','Purchase Voucher','Purchase Return','Payment Voucher','Receive Voucher','Expense Voucher','Contra Voucher') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Journal Voucher',
  `dr_cr_type` enum('DR','CR') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'DR',
  `dr_amount` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `cr_amount` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

CREATE TABLE `admins` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` enum('System User','Employee') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_id` bigint UNSIGNED DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `name`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`, `username`, `user_type`, `employee_id`, `avatar`) VALUES
(1, 'Admin', 'rashed.zamann@gmail.com', NULL, '$2y$12$r5vXnqLAvWSj09ke0L5/AeY0GIDf6DEheOSNNieC.A2IF0PqHxRU2', 'pKd556jjBOMzpCanm1oM4SDGRhIt2F3EpWYx8dI03RnJpVUa9jI2ZzWpB5C5', '2025-03-21 09:41:38', '2025-03-21 09:41:38', NULL, 'System User', NULL, NULL),
(6, 'Cally Finley', NULL, NULL, '$2y$12$LIc60VqdsnPz40XlGlZxAeFAnSvJNSRjMFinx0i5SOyfs1MzIH9q2', 'QZgBWXP3bJHNAPQzbMqIlJWLgMOdhv3PEP9yd3mFTIPhKKkNF3gZkm9spA13', '2025-03-29 12:03:32', '2025-04-05 08:05:18', 'zaman', 'Employee', 1, NULL),
(7, 'Test Admin', 'test@email.com', NULL, '$2y$12$ceuQdXc0yHOpQbpdNeV8veI6VgyaCduGh5RCAVcjlE2nQe2K2UF2u', NULL, '2025-04-05 04:49:25', '2025-04-05 04:49:25', NULL, 'System User', NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache_locks`
--

CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hrm_departments`
--

CREATE TABLE `hrm_departments` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hrm_designations`
--

CREATE TABLE `hrm_designations` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hrm_employees`
--

CREATE TABLE `hrm_employees` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_birth` date DEFAULT NULL,
  `joined_date` date DEFAULT NULL,
  `probation_end_date` date DEFAULT NULL,
  `date_of_permanent` date DEFAULT NULL,
  `national_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `departments_id` bigint UNSIGNED DEFAULT NULL,
  `designations_id` bigint UNSIGNED DEFAULT NULL,
  `business_units_id` bigint UNSIGNED DEFAULT NULL,
  `inventory_store_id` bigint UNSIGNED DEFAULT NULL,
  `religious` enum('Hinduism','Judaism','Buddhism','Christianity','Islam','Folk Religion','Other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `gender` enum('Male','Female','Third Gender') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Male',
  `marital_status` enum('Single','Married') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Single',
  `blood_group` enum('A+','A-','B+','B-','O+','O-','AB+','AB-') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hrm_employees`
--

INSERT INTO `hrm_employees` (`id`, `code`, `first_name`, `last_name`, `full_name`, `date_birth`, `joined_date`, `probation_end_date`, `date_of_permanent`, `national_id`, `phone`, `email`, `photo`, `country_id`, `departments_id`, `designations_id`, `business_units_id`, `inventory_store_id`, `religious`, `is_active`, `gender`, `marital_status`, `blood_group`, `serial`, `created_at`, `updated_at`) VALUES
(1, '00001', 'Cally', 'Finley', 'Cally Finley', '1973-05-20', NULL, NULL, NULL, '3445673', '2484721613', 'cally@gmail.com', 'profile1-1743862615.jpg', 18, NULL, NULL, 1, NULL, 'Islam', 'Active', 'Male', 'Single', 'A+', 1, '2025-03-21 10:26:22', '2025-04-05 08:16:55'),
(2, '00002', 'Evangeline', 'Banks', 'Evangeline Banks', '1987-10-12', NULL, NULL, NULL, '00726555', '+1 (376) 261-5577', 'cibalesal@mailinator.com', NULL, 18, NULL, NULL, 1, NULL, 'Islam', 'Active', 'Male', 'Single', 'B-', 1, '2025-03-21 10:34:15', '2025-03-21 10:34:15'),
(3, '00003', 'Francis', 'Kim', 'Francis Kim', '1991-04-14', NULL, NULL, NULL, '5667788', '+1 (515) 763-2734', 'xesirumu@mailinator.com', NULL, 18, NULL, NULL, 1, NULL, 'Islam', 'Active', 'Male', 'Single', 'AB-', 1, '2025-03-21 10:41:16', '2025-03-21 10:41:16');

-- --------------------------------------------------------

--
-- Table structure for table `hrm_employee_business_units`
--

CREATE TABLE `hrm_employee_business_units` (
  `id` bigint UNSIGNED NOT NULL,
  `employee_id` bigint UNSIGNED NOT NULL,
  `business_unit_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hrm_employee_business_units`
--

INSERT INTO `hrm_employee_business_units` (`id`, `employee_id`, `business_unit_id`, `created_at`, `updated_at`) VALUES
(1, 3, 1, NULL, NULL),
(2, 3, 3, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `hrm_employee_contacts`
--

CREATE TABLE `hrm_employee_contacts` (
  `id` bigint UNSIGNED NOT NULL,
  `employee_id` bigint UNSIGNED NOT NULL,
  `address_line_1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_line_2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `emp_phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `emp_email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `home_phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hrm_employee_stores`
--

CREATE TABLE `hrm_employee_stores` (
  `id` bigint UNSIGNED NOT NULL,
  `employee_id` bigint UNSIGNED NOT NULL,
  `store_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `hrm_employee_stores`
--

INSERT INTO `hrm_employee_stores` (`id`, `employee_id`, `store_id`, `created_at`, `updated_at`) VALUES
(1, 3, 5, NULL, NULL),
(2, 3, 9, NULL, NULL),
(3, 3, 10, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `inventory_attributes`
--

CREATE TABLE `inventory_attributes` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_attributes`
--

INSERT INTO `inventory_attributes` (`id`, `code`, `name`, `is_active`, `serial`, `created_at`, `updated_at`) VALUES
(1, '0001', 'Size', 'Active', 1, '2025-05-02 02:24:15', '2025-05-02 02:24:15'),
(4, '0002', 'Color', 'Active', 1, '2025-05-02 02:53:52', '2025-05-02 02:53:52');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_attribute_values`
--

CREATE TABLE `inventory_attribute_values` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `inventory_attribute_id` bigint UNSIGNED DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_attribute_values`
--

INSERT INTO `inventory_attribute_values` (`id`, `code`, `inventory_attribute_id`, `value`, `is_active`, `serial`, `created_at`, `updated_at`) VALUES
(1, '00001', 1, 'S', 'Active', 1, '2025-05-02 05:43:21', '2025-05-02 05:43:21'),
(2, '00002', 1, 'M', 'Active', 1, '2025-05-02 05:43:46', '2025-05-02 06:04:58'),
(3, '00003', 1, 'XL', 'Active', 1, '2025-05-02 06:05:18', '2025-05-02 06:05:18'),
(4, '00004', 1, 'XXL', 'Active', 1, '2025-05-02 06:05:31', '2025-05-02 06:05:31'),
(5, '00005', 4, 'Black', 'Active', 1, '2025-05-02 06:05:42', '2025-05-02 06:05:42'),
(6, '00006', 4, 'White', 'Active', 1, '2025-05-02 06:06:41', '2025-05-02 06:06:41'),
(7, '00007', 4, 'Blue', 'Active', 1, '2025-05-02 06:06:55', '2025-05-02 06:06:55');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_categories`
--

CREATE TABLE `inventory_categories` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint UNSIGNED DEFAULT NULL,
  `category_level` enum('Head','Group','Category','Sub Category','Sub Sub Category') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Sub Category',
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_categories`
--

INSERT INTO `inventory_categories` (`id`, `code`, `name`, `parent_id`, `category_level`, `is_active`, `serial`, `system`, `created_at`, `updated_at`, `url`) VALUES
(1, '01', 'Saleable Items', NULL, 'Head', 'Active', 1, 1, '2025-05-30 08:07:17', '2025-05-30 08:07:17', 'saleable-items'),
(2, '02', 'Raw Materials', NULL, 'Head', 'Active', 1, 1, '2025-05-30 08:07:31', '2025-05-30 08:07:31', 'raw-materials'),
(3, '03', 'Spare Parts', NULL, 'Head', 'Active', 1, 1, '2025-05-30 08:07:44', '2025-05-30 08:07:44', 'spare-parts'),
(4, '04', 'Fixed Assets', NULL, 'Head', 'Active', 1, 1, '2025-05-30 08:07:58', '2025-05-30 08:07:58', 'fixed-assets'),
(5, '0101', 'Phones', 1, 'Group', 'Active', 1, 0, '2025-05-30 09:43:07', '2025-05-30 09:43:07', 'phones'),
(6, '010101', 'iPhone', 5, 'Category', 'Active', 1, 0, '2025-05-30 10:03:22', '2025-05-30 10:03:22', 'iphone'),
(7, '010102', 'Samsung', 5, 'Category', 'Active', 1, 0, '2025-05-30 10:03:34', '2025-05-30 10:03:34', 'samsung'),
(8, '0102', 'Phone Accessories', 1, 'Group', 'Active', 1, 0, '2025-05-30 10:04:11', '2025-05-30 10:04:11', 'phone-accessories'),
(9, '010201', 'Case & Screen Protector', 8, 'Category', 'Active', 1, 0, '2025-05-30 10:04:45', '2025-05-30 10:04:45', 'case-screen-protector'),
(10, '01020101', 'Phone Case', 9, 'Sub Category', 'Active', 1, 0, '2025-05-30 10:05:06', '2025-05-30 10:28:30', 'apple'),
(11, '01020102', 'Screen Protector', 9, 'Sub Category', 'Active', 1, 0, '2025-05-30 10:05:16', '2025-05-30 10:29:02', 'samsung-1'),
(12, '010202', 'Power Bank', 8, 'Category', 'Active', 1, 0, '2025-05-30 10:05:35', '2025-05-30 10:05:35', 'power-bank'),
(13, '0102010101', 'iPhone', 10, 'Sub Sub Category', 'Active', 1, 0, '2025-05-30 10:29:18', '2025-05-30 10:29:18', 'iphone-1'),
(14, '0102010102', 'Samsung', 10, 'Sub Sub Category', 'Active', 1, 0, '2025-05-30 10:29:26', '2025-05-30 10:29:26', 'samsung-2'),
(16, '0102010201', 'iPhone', 11, 'Sub Sub Category', 'Active', 1, 0, '2025-05-30 11:00:46', '2025-05-30 11:00:46', 'iphone-2'),
(17, '0102010202', 'Samsung', 11, 'Sub Sub Category', 'Active', 1, 0, '2025-05-30 11:00:58', '2025-05-30 11:00:58', 'samsung-3'),
(18, '0103', 'Men', 1, 'Group', 'Active', 1, 0, '2025-05-30 11:13:11', '2025-05-30 11:13:11', 'men'),
(22, '010301', 'Western Wear', 18, 'Category', 'Active', 1, 0, '2025-05-30 11:17:23', '2025-05-30 11:17:23', 'western-wear'),
(23, '01030101', 'Casual Shirts', 22, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:17:53', '2025-05-30 11:17:53', 'casual-shirts'),
(24, '01030102', 'Formal Shirts', 22, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:18:04', '2025-05-30 11:18:04', 'formal-shirts'),
(25, '01030103', 'T-Shirts', 22, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:18:33', '2025-05-30 11:18:33', 't-shirts'),
(26, '010302', 'Ethnic Wear', 18, 'Category', 'Active', 1, 0, '2025-05-30 11:19:05', '2025-05-30 11:19:05', 'ethnic-wear'),
(27, '01030201', 'Panjabi', 26, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:19:21', '2025-05-30 11:19:21', 'panjabi'),
(28, '01030202', 'Fatua', 26, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:19:42', '2025-05-30 11:19:42', 'fatua'),
(29, '0104', 'Women', 1, 'Group', 'Active', 1, 0, '2025-05-30 11:20:43', '2025-05-30 11:20:43', 'women'),
(30, '010401', 'Western Wear', 29, 'Category', 'Active', 1, 0, '2025-05-30 11:21:08', '2025-05-30 11:21:08', 'western-wear-1'),
(31, '010402', 'Ethnic Wear', 29, 'Category', 'Active', 1, 0, '2025-05-30 11:21:27', '2025-05-30 11:21:27', 'ethnic-wear-1'),
(32, '01040101', 'Fashion Tops and Casual Shirts', 30, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:21:59', '2025-05-30 11:21:59', 'fashion-tops-and-casual-shirts'),
(33, '01040102', 'T-Shirts', 30, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:22:33', '2025-05-30 11:22:33', 't-shirts-1'),
(34, '01040201', 'Ethnic Kurtis and Kurtas', 31, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:24:57', '2025-05-30 11:24:57', 'ethnic-kurtis-and-kurtas'),
(35, '01040202', 'Two-Piece Lawns', 31, 'Sub Category', 'Active', 1, 0, '2025-05-30 11:25:37', '2025-05-30 11:25:37', 'two-piece-lawns');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_items`
--

CREATE TABLE `inventory_items` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint UNSIGNED NOT NULL,
  `brand_id` bigint UNSIGNED DEFAULT NULL,
  `is_variant` tinyint(1) DEFAULT '0',
  `sales_price` decimal(13,2) NOT NULL DEFAULT '0.00',
  `purchase_unit` int DEFAULT NULL,
  `sales_unit` int DEFAULT NULL,
  `unit_conversion` decimal(8,2) DEFAULT NULL,
  `item_type` enum('Salabel','General') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_type` enum('Yes','No') COLLATE utf8mb4_unicode_ci DEFAULT 'No',
  `serial_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lot_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hscode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chosen_attribute` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `choice_options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `chosen_attribute_options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `chosen_attribute_option_values` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `variations` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `discount` decimal(8,2) DEFAULT NULL,
  `discount_type` enum('Flat','Price') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_start_date` date DEFAULT NULL,
  `discount_end_date` date DEFAULT NULL,
  `taxes_id` bigint UNSIGNED DEFAULT NULL,
  `item_img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` enum('Published','Draft') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Draft',
  `serial` int DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_items`
--

INSERT INTO `inventory_items` (`id`, `code`, `slug`, `title`, `category_id`, `brand_id`, `is_variant`, `sales_price`, `purchase_unit`, `sales_unit`, `unit_conversion`, `item_type`, `purchase_type`, `serial_no`, `lot_no`, `hscode`, `chosen_attribute`, `choice_options`, `chosen_attribute_options`, `chosen_attribute_option_values`, `variations`, `description`, `discount`, `discount_type`, `discount_start_date`, `discount_end_date`, `taxes_id`, `item_img`, `published`, `serial`, `created_at`, `updated_at`) VALUES
(1, '000001', 't-shirt', 'T-Shirt', 25, 1, 1, 299.00, 2, 2, 1.00, 'Salabel', 'Yes', '1244452', 'Lot2345', '44555', NULL, NULL, NULL, NULL, NULL, 'T-Shirt Description', NULL, NULL, NULL, NULL, 1, 'speaker_1749835799.png', 'Draft', 1, '2025-06-11 22:56:55', '2025-06-13 11:29:59'),
(2, '000002', 'iphone-17-pro', 'iPhone 17 Pro', 6, 1, 0, 5000.00, 1, 1, 1.00, 'Salabel', 'Yes', '45', '34', '34', NULL, NULL, NULL, NULL, NULL, 'iPhone 17 Pro', NULL, NULL, NULL, NULL, 1, NULL, 'Draft', 1, '2025-06-13 03:29:11', '2025-06-13 03:31:20');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_attributes`
--

CREATE TABLE `inventory_item_attributes` (
  `id` bigint UNSIGNED NOT NULL,
  `inventory_item_id` bigint UNSIGNED NOT NULL,
  `inventory_attribute_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_item_attributes`
--

INSERT INTO `inventory_item_attributes` (`id`, `inventory_item_id`, `inventory_attribute_id`, `created_at`, `updated_at`) VALUES
(2, 1, 1, NULL, NULL),
(3, 1, 4, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_brands`
--

CREATE TABLE `inventory_item_brands` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_item_brands`
--

INSERT INTO `inventory_item_brands` (`id`, `code`, `name`, `logo`, `slug`, `meta_title`, `meta_description`, `is_active`, `serial`, `created_at`, `updated_at`) VALUES
(1, '01', 'Artisan', NULL, 'artisan', NULL, NULL, 'Active', 1, '2025-04-17 17:39:44', '2025-04-17 17:41:39'),
(2, '0002', 'Sony', NULL, 'sony', NULL, NULL, 'Active', 1, '2025-04-17 17:41:49', '2025-04-17 17:41:49');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_requisitions`
--

CREATE TABLE `inventory_item_requisitions` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` date DEFAULT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `departments_id` bigint UNSIGNED DEFAULT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `requisition_status` enum('Draft','Pending','Process','Approved','Complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_requisition_lines`
--

CREATE TABLE `inventory_item_requisition_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `item_requisition_id` bigint UNSIGNED NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` int DEFAULT NULL,
  `item_id` bigint UNSIGNED NOT NULL,
  `unit_id` bigint UNSIGNED NOT NULL,
  `unit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_skus`
--

CREATE TABLE `inventory_item_skus` (
  `id` bigint UNSIGNED NOT NULL,
  `sku_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inventory_item_id` bigint UNSIGNED NOT NULL,
  `attribute_value_map` json DEFAULT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `buying_price` decimal(8,2) DEFAULT '0.00',
  `selling_price` decimal(8,2) DEFAULT '0.00',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_item_skus`
--

INSERT INTO `inventory_item_skus` (`id`, `sku_code`, `inventory_item_id`, `attribute_value_map`, `is_variant`, `sku`, `buying_price`, `selling_price`, `image`, `is_active`, `serial`, `created_at`, `updated_at`) VALUES
(1, 'M-Blue', 1, '[{\"value_id\": \"5\", \"attribute_id\": \"4\"}, {\"value_id\": \"3\", \"attribute_id\": \"1\"}]', 1, '1749704215-4216', 0.00, 599.00, NULL, 'Active', 1, '2025-06-11 22:56:55', '2025-06-13 11:29:59'),
(2, 'M-Black', 1, '[{\"value_id\": \"5\", \"attribute_id\": \"4\"}, {\"value_id\": \"2\", \"attribute_id\": \"1\"}]', 1, '1749759846-1037', 0.00, 199.00, NULL, 'Active', 1, '2025-06-12 14:24:06', '2025-06-13 11:29:59'),
(3, 'XL-Blue', 1, '[{\"value_id\": \"7\", \"attribute_id\": \"4\"}, {\"value_id\": \"3\", \"attribute_id\": \"1\"}]', 1, '1749759846-6885', 0.00, 899.00, NULL, 'Active', 1, '2025-06-12 14:24:06', '2025-06-13 11:29:59'),
(4, 'XL-Black', 1, '[{\"value_id\": \"7\", \"attribute_id\": \"4\"}, {\"value_id\": \"2\", \"attribute_id\": \"1\"}]', 1, '1749759846-5278', 0.00, 699.00, NULL, 'Active', 1, '2025-06-12 14:24:06', '2025-06-13 11:29:59'),
(5, 'S-Blue', 1, '[{\"value_id\": \"6\", \"attribute_id\": \"4\"}, {\"value_id\": \"3\", \"attribute_id\": \"1\"}]', 1, '1749759846-4307', 0.00, 399.00, NULL, 'Active', 1, '2025-06-12 14:24:06', '2025-06-12 16:22:45'),
(6, 'S-Black', 1, '[{\"value_id\": \"6\", \"attribute_id\": \"4\"}, {\"value_id\": \"2\", \"attribute_id\": \"1\"}]', 1, '1749759846-1631', 0.00, 399.00, NULL, 'Active', 1, '2025-06-12 14:24:06', '2025-06-12 16:22:45'),
(7, 'M-White', 1, '[{\"value_id\": \"5\", \"attribute_id\": \"4\"}, {\"value_id\": \"1\", \"attribute_id\": \"1\"}]', 1, '1749765448-6892', 0.00, 499.00, NULL, 'Active', 1, '2025-06-12 15:57:28', '2025-06-12 16:22:45'),
(8, 'XL-White', 1, '[{\"value_id\": \"7\", \"attribute_id\": \"4\"}, {\"value_id\": \"1\", \"attribute_id\": \"1\"}]', 1, '1749765448-5600', 0.00, 799.00, NULL, 'Active', 1, '2025-06-12 15:57:28', '2025-06-12 16:22:45'),
(9, 'S-White', 1, '[{\"value_id\": \"6\", \"attribute_id\": \"4\"}, {\"value_id\": \"1\", \"attribute_id\": \"1\"}]', 1, '1749766642-5006', 0.00, 299.00, NULL, 'Active', 1, '2025-06-12 16:17:22', '2025-06-12 16:22:45'),
(10, NULL, 2, NULL, 0, '1749806951-2726', 0.00, 5000.00, NULL, 'Active', 1, '2025-06-13 03:29:11', '2025-06-13 03:31:20');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_sku_attribute_values`
--

CREATE TABLE `inventory_item_sku_attribute_values` (
  `id` bigint UNSIGNED NOT NULL,
  `inventory_item_sku_id` bigint UNSIGNED NOT NULL,
  `inventory_attribute_id` bigint UNSIGNED NOT NULL,
  `inventory_attribute_value_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_item_sku_attribute_values`
--

INSERT INTO `inventory_item_sku_attribute_values` (`id`, `inventory_item_sku_id`, `inventory_attribute_id`, `inventory_attribute_value_id`, `created_at`, `updated_at`) VALUES
(241, 2, 4, 5, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(242, 2, 1, 2, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(243, 1, 4, 5, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(244, 1, 1, 3, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(245, 4, 4, 7, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(246, 4, 1, 2, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(247, 3, 4, 7, '2025-06-13 11:29:59', '2025-06-13 11:29:59'),
(248, 3, 1, 3, '2025-06-13 11:29:59', '2025-06-13 11:29:59');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_taxes`
--

CREATE TABLE `inventory_item_taxes` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax` decimal(8,2) NOT NULL,
  `calculation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `serial` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_item_taxes`
--

INSERT INTO `inventory_item_taxes` (`id`, `code`, `name`, `tax`, `calculation`, `is_active`, `serial`, `created_at`, `updated_at`) VALUES
(1, '01', '15%Tax', 15.00, 'percent', 'Active', 1, '2025-04-17 10:57:45', '2025-04-17 14:25:58'),
(2, '02', '50 Flat', 15.00, 'flat', 'Active', 1, '2025-04-17 14:26:35', '2025-04-17 14:26:35');

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_transactions`
--

CREATE TABLE `inventory_item_transactions` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_type` enum('Opening Balance','Closing Balance','GRN','Goods Delivery','Direct Issue','Direct Receive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sales_order_id` bigint UNSIGNED DEFAULT NULL,
  `purchase_order_id` bigint UNSIGNED DEFAULT NULL,
  `item_requisition_id` bigint UNSIGNED DEFAULT NULL,
  `inventory_periods_id` bigint UNSIGNED DEFAULT NULL,
  `inventory_store_id` bigint UNSIGNED DEFAULT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inventory_item_transaction_lines`
--

CREATE TABLE `inventory_item_transaction_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `transaction_id` bigint UNSIGNED NOT NULL,
  `sales_line_id` bigint UNSIGNED DEFAULT NULL,
  `purchase_line_id` bigint UNSIGNED DEFAULT NULL,
  `requisition_line_id` bigint UNSIGNED DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `period_id` bigint UNSIGNED NOT NULL,
  `item_id` bigint UNSIGNED NOT NULL,
  `unit_id` bigint UNSIGNED NOT NULL,
  `unit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('Opening Balance','Closing Balance','GRN','Goods Delivery','Direct Issue','Direct Receive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_mode` enum('Issue','Receive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `issue_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `receive_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `line_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inventory_periods`
--

CREATE TABLE `inventory_periods` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `open_status` enum('Void','Open','Close') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Void',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inventory_units`
--

CREATE TABLE `inventory_units` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `inventory_units`
--

INSERT INTO `inventory_units` (`id`, `code`, `name`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '01', 'PC', 'Active', '2025-04-16 18:31:51', '2025-04-16 18:45:14'),
(2, '02', 'KG', 'Active', '2025-04-16 18:45:37', '2025-04-16 18:45:37'),
(3, '03', 'Ltr', 'Active', '2025-04-16 18:45:51', '2025-04-16 18:45:51'),
(4, '04', '15%Tax', 'Active', '2025-04-17 10:24:27', '2025-04-17 10:24:27');

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint UNSIGNED NOT NULL,
  `reserved_at` int UNSIGNED DEFAULT NULL,
  `available_at` int UNSIGNED NOT NULL,
  `created_at` int UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int UNSIGNED NOT NULL,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '0001_01_01_000000_create_users_table', 1),
(2, '0001_01_01_000001_create_cache_table', 1),
(3, '0001_01_01_000002_create_jobs_table', 1),
(4, '2024_07_11_095502_create_admins_table', 1),
(5, '2024_07_12_105433_setup_location', 1),
(6, '2024_07_12_111110_setup_companies', 1),
(7, '2024_07_12_123332_accounts_setup', 1),
(8, '2024_07_12_142341_accounts_transaction', 1),
(9, '2024_07_12_160952_inventory_setup', 1),
(10, '2024_07_13_020320_inventory_item', 1),
(11, '2024_07_13_175849_employee_setup', 1),
(12, '2024_07_13_204519_sales_setup', 1),
(13, '2024_07_13_204529_sales_transaction', 1),
(14, '2024_07_13_204531_purchase_setup', 1),
(15, '2024_07_13_204725_purchase_transaction', 1),
(16, '2024_07_13_214725_inventory_item_transaction', 1),
(17, '2024_11_30_161226_hrm_employee_contacts', 1),
(18, '2025_01_29_165708_employee_business_unit_store', 1),
(19, '2025_03_19_190747_create_permission_tables', 1),
(20, '2025_03_19_213054_add_group_name_to_permissions_table', 1),
(21, '2025_03_21_180800_add_columns_admin_table', 2),
(22, '2025_04_09_165926_add_columns_url_inventory_categories', 3),
(23, '2025_04_18_121058_add_columns_inventory_item_option_id_at_inventory_item_option_values_table', 4);

-- --------------------------------------------------------

--
-- Table structure for table `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint UNSIGNED NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint UNSIGNED NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1, 'App\\Models\\Admin', 1),
(1, 'App\\Models\\Admin', 2),
(2, 'App\\Models\\Admin', 3),
(2, 'App\\Models\\Admin', 4),
(2, 'App\\Models\\Admin', 5),
(1, 'App\\Models\\Admin', 6),
(3, 'App\\Models\\Admin', 6),
(2, 'App\\Models\\Admin', 7);

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `group_name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'access dashboard', 'Dashboard', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(2, 'create user', 'User Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(3, 'view user', 'User Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(4, 'edit user', 'User Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(5, 'delete user', 'User Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(6, 'create role', 'Role Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(7, 'view role', 'Role Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(8, 'edit role', 'Role Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(9, 'delete role', 'Role Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(10, 'create product', 'Product Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(11, 'view product', 'Product Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(12, 'edit product', 'Product Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(13, 'delete product', 'Product Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(14, 'create post', 'Post Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(15, 'view post', 'Post Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(16, 'edit post', 'Post Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(17, 'delete post', 'Post Management', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(18, 'access settings', 'Settings', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38');

-- --------------------------------------------------------

--
-- Table structure for table `purchase_item_requisitions`
--

CREATE TABLE `purchase_item_requisitions` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` date DEFAULT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `item_requisition_id` bigint UNSIGNED DEFAULT NULL,
  `departments_id` bigint UNSIGNED DEFAULT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `requisition_status` enum('Draft','Pending','Process','Approved','Complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_item_requisition_lines`
--

CREATE TABLE `purchase_item_requisition_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `item_requisition_id` bigint UNSIGNED NOT NULL,
  `item_requisition_line_id` bigint UNSIGNED DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` int DEFAULT NULL,
  `item_id` bigint UNSIGNED NOT NULL,
  `unit_id` bigint UNSIGNED NOT NULL,
  `unit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_orders`
--

CREATE TABLE `purchase_orders` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` date DEFAULT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `supplier_id` bigint UNSIGNED NOT NULL,
  `item_requisition_id` bigint UNSIGNED DEFAULT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `purchase_status` enum('Draft','Pending','Process','Approved','Complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_lines`
--

CREATE TABLE `purchase_order_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `purchase_order_id` bigint UNSIGNED NOT NULL,
  `item_requisition_line_id` bigint UNSIGNED DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` int DEFAULT NULL,
  `item_id` bigint UNSIGNED NOT NULL,
  `unit_id` bigint UNSIGNED NOT NULL,
  `unit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `line_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_suppliers`
--

CREATE TABLE `purchase_suppliers` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `website` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint UNSIGNED DEFAULT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(2, 'Admin', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(3, 'Manager', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(4, 'Editor', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38'),
(5, 'User', 'admin', '2025-03-21 09:41:38', '2025-03-21 09:41:38');

-- --------------------------------------------------------

--
-- Table structure for table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint UNSIGNED NOT NULL,
  `role_id` bigint UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 1),
(16, 1),
(17, 1),
(18, 1),
(1, 2),
(2, 2),
(3, 2),
(4, 2),
(6, 2),
(7, 2),
(8, 2),
(10, 2),
(11, 2),
(12, 2),
(13, 2),
(14, 2),
(15, 2),
(16, 2),
(17, 2),
(1, 3),
(3, 3),
(10, 3),
(11, 3),
(12, 3),
(1, 4),
(14, 4),
(15, 4),
(16, 4),
(11, 5),
(15, 5);

-- --------------------------------------------------------

--
-- Table structure for table `sales_billing_addresses`
--

CREATE TABLE `sales_billing_addresses` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sales_order_id` bigint UNSIGNED NOT NULL,
  `setup_country` bigint UNSIGNED NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` text COLLATE utf8mb4_unicode_ci,
  `state` text COLLATE utf8mb4_unicode_ci,
  `zip` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_customers`
--

CREATE TABLE `sales_customers` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `website` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `setup_country_id` bigint UNSIGNED DEFAULT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `admin_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_customer_billing_addresses`
--

CREATE TABLE `sales_customer_billing_addresses` (
  `id` bigint UNSIGNED NOT NULL,
  `sales_customer_id` bigint UNSIGNED NOT NULL,
  `setup_country` bigint UNSIGNED NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` text COLLATE utf8mb4_unicode_ci,
  `state` text COLLATE utf8mb4_unicode_ci,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_customer_shipping_addresses`
--

CREATE TABLE `sales_customer_shipping_addresses` (
  `id` bigint UNSIGNED NOT NULL,
  `sales_customer_id` bigint UNSIGNED NOT NULL,
  `setup_country` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` text COLLATE utf8mb4_unicode_ci,
  `state` text COLLATE utf8mb4_unicode_ci,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_orders`
--

CREATE TABLE `sales_orders` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` date DEFAULT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `sales_quotation_id` bigint UNSIGNED DEFAULT NULL,
  `customer_id` bigint UNSIGNED NOT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `sales_status` enum('Draft','Pending','Process','Approved','Complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_order_lines`
--

CREATE TABLE `sales_order_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `sales_order_id` bigint UNSIGNED NOT NULL,
  `sales_quotation_line_id` bigint UNSIGNED DEFAULT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` int DEFAULT NULL,
  `item_id` bigint UNSIGNED NOT NULL,
  `unit_id` bigint UNSIGNED NOT NULL,
  `unit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `line_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_quotations`
--

CREATE TABLE `sales_quotations` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` date DEFAULT NULL,
  `narration` text COLLATE utf8mb4_unicode_ci,
  `customer_id` bigint UNSIGNED NOT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `sales_status` enum('Draft','Pending','Process','Approved','Complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `approve_status` enum('Draft','Confirm','Approve','Reject') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by_time` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_quotation_lines`
--

CREATE TABLE `sales_quotation_lines` (
  `id` bigint UNSIGNED NOT NULL,
  `sales_quotation_id` bigint UNSIGNED NOT NULL,
  `transaction_date` date NOT NULL,
  `lead_date` int DEFAULT NULL,
  `item_id` bigint UNSIGNED NOT NULL,
  `unit_id` bigint UNSIGNED NOT NULL,
  `unit_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_quantity` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `line_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `narration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sales_shipping_addresses`
--

CREATE TABLE `sales_shipping_addresses` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sales_order_id` bigint UNSIGNED NOT NULL,
  `setup_country` bigint UNSIGNED NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` text COLLATE utf8mb4_unicode_ci,
  `state` text COLLATE utf8mb4_unicode_ci,
  `zip` text COLLATE utf8mb4_unicode_ci,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sessions`
--

INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
('ioUNtUnw8zI7TFxzWi3igEhvJHS8xEB5IVIkpa1v', NULL, '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36', 'YTo0OntzOjY6Il90b2tlbiI7czo0MDoiNWtOTzBZakZuMVVKeE1NMEFQQ0xjNnN4RzllR0g3Z2dsenNseExCNiI7czo1MjoibG9naW5fYWRtaW5fNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToxO3M6OToiX3ByZXZpb3VzIjthOjE6e3M6MzoidXJsIjtzOjQ4OiJodHRwOi8vemVycC50ZXN0L2FkbWluL2ludmVudG9yeS9lZGl0SXRlbS8wMDAwMDEiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19', 1749835817);

-- --------------------------------------------------------

--
-- Table structure for table `setup_business_units`
--

CREATE TABLE `setup_business_units` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companies_id` bigint UNSIGNED NOT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `users_id` bigint UNSIGNED NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `setup_business_units`
--

INSERT INTO `setup_business_units` (`id`, `code`, `name`, `short_name`, `code_prefix`, `phone`, `email`, `address`, `city`, `state`, `zip`, `companies_id`, `country_id`, `logo`, `users_id`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '0001', 'Dhanmondi Branch', 'Amela Burton', 'BU', '+1 (562) 524-1004', 'ruwoce@mailinator.com', 'Non provident natus', 'Dhaka', 'Dhanmondi', '34589', 1, 18, NULL, 1, 'Active', '2024-09-21 03:41:42', '2024-10-06 03:49:37'),
(2, '0002', 'Uttara Branch', 'Hunter Bird', 'BU', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 1, 18, NULL, 1, 'Active', '2024-09-23 06:11:48', '2024-10-08 23:33:02'),
(3, '0003', 'Mirpur Branch', 'Joy Baker', 'BU', '+1 (983) 132-5414', 'vatexypov@mailinator.com', 'Sint eaque ipsum co', 'Dhaka', 'Mirpur', '12560', 1, 18, NULL, 1, 'Active', '2024-09-23 06:13:38', '2024-10-06 03:50:30'),
(4, '0004', 'Gulshan Branch', 'Stewart Irwin', 'BU', '+1 (372) 713-3401', 'wazybyve@mailinator.com', 'Debitis accusantium', 'Dhaka', 'Gulshan', '97703', 1, 18, NULL, 1, 'Active', '2024-09-23 06:14:24', '2024-10-06 03:51:27');

-- --------------------------------------------------------

--
-- Table structure for table `setup_companies`
--

CREATE TABLE `setup_companies` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_symbol` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `setup_companies`
--

INSERT INTO `setup_companies` (`id`, `code`, `name`, `short_name`, `phone`, `email`, `website`, `address`, `city`, `state`, `zip`, `currency_symbol`, `country_id`, `logo`, `is_active`, `created_at`, `updated_at`) VALUES
(1, '0001', 'AmanatShah Fabrics', 'ASFL', '00880298880009', 'asfl@gmail.com', 'www.asfl.com', '10/9, Level 24, City Center, Motijheel', 'Dhaka', 'Motijheel', '1000', '৳', 98, 'logo-1726843718.png', 'Active', NULL, '2024-10-10 02:09:16');

-- --------------------------------------------------------

--
-- Table structure for table `setup_countries`
--

CREATE TABLE `setup_countries` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `setup_countries`
--

INSERT INTO `setup_countries` (`id`, `code`, `name`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'AF', 'Afghanistan', 'Active', NULL, NULL),
(2, 'AL', 'Albania', 'Active', NULL, NULL),
(3, 'DZ', 'Algeria', 'Active', NULL, NULL),
(4, 'DS', 'American Samoa', 'Active', NULL, NULL),
(5, 'AD', 'Andorra', 'Active', NULL, NULL),
(6, 'AO', 'Angola', 'Active', NULL, NULL),
(7, 'AI', 'Anguilla', 'Active', NULL, NULL),
(8, 'AQ', 'Antarctica', 'Active', NULL, NULL),
(9, 'AG', 'Antigua and Barbuda', 'Active', NULL, NULL),
(10, 'AR', 'Argentina', 'Active', NULL, NULL),
(11, 'AM', 'Armenia', 'Active', NULL, NULL),
(12, 'AW', 'Aruba', 'Active', NULL, NULL),
(13, 'AU', 'Australia', 'Active', NULL, NULL),
(14, 'AT', 'Austria', 'Active', NULL, NULL),
(15, 'AZ', 'Azerbaijan', 'Active', NULL, NULL),
(16, 'BS', 'Bahamas', 'Active', NULL, NULL),
(17, 'BH', 'Bahrain', 'Active', NULL, NULL),
(18, 'BD', 'Bangladesh', 'Active', NULL, NULL),
(19, 'BB', 'Barbados', 'Active', NULL, NULL),
(20, 'BY', 'Belarus', 'Active', NULL, NULL),
(21, 'BE', 'Belgium', 'Active', NULL, NULL),
(22, 'BZ', 'Belize', 'Active', NULL, NULL),
(23, 'BJ', 'Benin', 'Active', NULL, NULL),
(24, 'BM', 'Bermuda', 'Active', NULL, NULL),
(25, 'BT', 'Bhutan', 'Active', NULL, NULL),
(26, 'BO', 'Bolivia', 'Active', NULL, NULL),
(27, 'BA', 'Bosnia and Herzegovina', 'Active', NULL, NULL),
(28, 'BW', 'Botswana', 'Active', NULL, NULL),
(29, 'BV', 'Bouvet Island', 'Active', NULL, NULL),
(30, 'BR', 'Brazil', 'Active', NULL, NULL),
(31, 'IO', 'British Indian Ocean Territory', 'Active', NULL, NULL),
(32, 'BN', 'Brunei Darussalam', 'Active', NULL, NULL),
(33, 'BG', 'Bulgaria', 'Active', NULL, NULL),
(34, 'BF', 'Burkina Faso', 'Active', NULL, NULL),
(35, 'BI', 'Burundi', 'Active', NULL, NULL),
(36, 'KH', 'Cambodia', 'Active', NULL, NULL),
(37, 'CM', 'Cameroon', 'Active', NULL, NULL),
(38, 'CA', 'Canada', 'Active', NULL, NULL),
(39, 'CV', 'Cape Verde', 'Active', NULL, NULL),
(40, 'KY', 'Cayman Islands', 'Active', NULL, NULL),
(41, 'CF', 'Central African Republic', 'Active', NULL, NULL),
(42, 'TD', 'Chad', 'Active', NULL, NULL),
(43, 'CL', 'Chile', 'Active', NULL, NULL),
(44, 'CN', 'China', 'Active', NULL, NULL),
(45, 'CX', 'Christmas Island', 'Active', NULL, NULL),
(46, 'CC', 'Cocos (Keeling) Islands', 'Active', NULL, NULL),
(47, 'CO', 'Colombia', 'Active', NULL, NULL),
(48, 'KM', 'Comoros', 'Active', NULL, NULL),
(49, 'CG', 'Congo', 'Active', NULL, NULL),
(50, 'CK', 'Cook Islands', 'Active', NULL, NULL),
(51, 'CR', 'Costa Rica', 'Active', NULL, NULL),
(52, 'HR', 'Croatia (Hrvatska)', 'Active', NULL, NULL),
(53, 'CU', 'Cuba', 'Active', NULL, NULL),
(54, 'CY', 'Cyprus', 'Active', NULL, NULL),
(55, 'CZ', 'Czech Republic', 'Active', NULL, NULL),
(56, 'DK', 'Denmark', 'Active', NULL, NULL),
(57, 'DJ', 'Djibouti', 'Active', NULL, NULL),
(58, 'DM', 'Dominica', 'Active', NULL, NULL),
(59, 'DO', 'Dominican Republic', 'Active', NULL, NULL),
(60, 'TP', 'East Timor', 'Active', NULL, NULL),
(61, 'EC', 'Ecuador', 'Active', NULL, NULL),
(62, 'EG', 'Egypt', 'Active', NULL, NULL),
(63, 'SV', 'El Salvador', 'Active', NULL, NULL),
(64, 'GQ', 'Equatorial Guinea', 'Active', NULL, NULL),
(65, 'ER', 'Eritrea', 'Active', NULL, NULL),
(66, 'EE', 'Estonia', 'Active', NULL, NULL),
(67, 'ET', 'Ethiopia', 'Active', NULL, NULL),
(68, 'FK', 'Falkland Islands (Malvinas)', 'Active', NULL, NULL),
(69, 'FO', 'Faroe Islands', 'Active', NULL, NULL),
(70, 'FJ', 'Fiji', 'Active', NULL, NULL),
(71, 'FI', 'Finland', 'Active', NULL, NULL),
(72, 'FR', 'France', 'Active', NULL, NULL),
(73, 'FX', 'France, Metropolitan', 'Active', NULL, NULL),
(74, 'GF', 'French Guiana', 'Active', NULL, NULL),
(75, 'PF', 'French Polynesia', 'Active', NULL, NULL),
(76, 'TF', 'French Southern Territories', 'Active', NULL, NULL),
(77, 'GA', 'Gabon', 'Active', NULL, NULL),
(78, 'GM', 'Gambia', 'Active', NULL, NULL),
(79, 'GE', 'Georgia', 'Active', NULL, NULL),
(80, 'DE', 'Germany', 'Active', NULL, NULL),
(81, 'GH', 'Ghana', 'Active', NULL, NULL),
(82, 'GI', 'Gibraltar', 'Active', NULL, NULL),
(83, 'GK', 'Guernsey', 'Active', NULL, NULL),
(84, 'GR', 'Greece', 'Active', NULL, NULL),
(85, 'GL', 'Greenland', 'Active', NULL, NULL),
(86, 'GD', 'Grenada', 'Active', NULL, NULL),
(87, 'GP', 'Guadeloupe', 'Active', NULL, NULL),
(88, 'GU', 'Guam', 'Active', NULL, NULL),
(89, 'GT', 'Guatemala', 'Active', NULL, NULL),
(90, 'GN', 'Guinea', 'Active', NULL, NULL),
(91, 'GW', 'Guinea-Bissau', 'Active', NULL, NULL),
(92, 'GY', 'Guyana', 'Active', NULL, NULL),
(93, 'HT', 'Haiti', 'Active', NULL, NULL),
(94, 'HM', 'Heard and Mc Donald Islands', 'Active', NULL, NULL),
(95, 'HN', 'Honduras', 'Active', NULL, NULL),
(96, 'HK', 'Hong Kong', 'Active', NULL, NULL),
(97, 'HU', 'Hungary', 'Active', NULL, NULL),
(98, 'IS', 'Iceland', 'Active', NULL, NULL),
(99, 'IN', 'India', 'Active', NULL, NULL),
(100, 'IM', 'Isle of Man', 'Active', NULL, NULL),
(101, 'ID', 'Indonesia', 'Active', NULL, NULL),
(102, 'IR', 'Iran (Islamic Republic of)', 'Active', NULL, NULL),
(103, 'IQ', 'Iraq', 'Active', NULL, NULL),
(104, 'IE', 'Ireland', 'Active', NULL, NULL),
(105, 'IL', 'Israel', 'Active', NULL, NULL),
(106, 'IT', 'Italy', 'Active', NULL, NULL),
(107, 'CI', 'Ivory Coast', 'Active', NULL, NULL),
(108, 'JE', 'Jersey', 'Active', NULL, NULL),
(109, 'JM', 'Jamaica', 'Active', NULL, NULL),
(110, 'JP', 'Japan', 'Active', NULL, NULL),
(111, 'JO', 'Jordan', 'Active', NULL, NULL),
(112, 'KZ', 'Kazakhstan', 'Active', NULL, NULL),
(113, 'KE', 'Kenya', 'Active', NULL, NULL),
(114, 'KI', 'Kiribati', 'Active', NULL, NULL),
(115, 'KP', 'Korea, Democratic People\'s Republic of', 'Active', NULL, NULL),
(116, 'KR', 'Korea, Republic of', 'Active', NULL, NULL),
(117, 'XK', 'Kosovo', 'Active', NULL, NULL),
(118, 'KW', 'Kuwait', 'Active', NULL, NULL),
(119, 'KG', 'Kyrgyzstan', 'Active', NULL, NULL),
(120, 'LA', 'Lao People\'s Democratic Republic', 'Active', NULL, NULL),
(121, 'LV', 'Latvia', 'Active', NULL, NULL),
(122, 'LB', 'Lebanon', 'Active', NULL, NULL),
(123, 'LS', 'Lesotho', 'Active', NULL, NULL),
(124, 'LR', 'Liberia', 'Active', NULL, NULL),
(125, 'LY', 'Libyan Arab Jamahiriya', 'Active', NULL, NULL),
(126, 'LI', 'Liechtenstein', 'Active', NULL, NULL),
(127, 'LT', 'Lithuania', 'Active', NULL, NULL),
(128, 'LU', 'Luxembourg', 'Active', NULL, NULL),
(129, 'MO', 'Macau', 'Active', NULL, NULL),
(130, 'MK', 'Macedonia', 'Active', NULL, NULL),
(131, 'MG', 'Madagascar', 'Active', NULL, NULL),
(132, 'MW', 'Malawi', 'Active', NULL, NULL),
(133, 'MY', 'Malaysia', 'Active', NULL, NULL),
(134, 'MV', 'Maldives', 'Active', NULL, NULL),
(135, 'ML', 'Mali', 'Active', NULL, NULL),
(136, 'MT', 'Malta', 'Active', NULL, NULL),
(137, 'MH', 'Marshall Islands', 'Active', NULL, NULL),
(138, 'MQ', 'Martinique', 'Active', NULL, NULL),
(139, 'MR', 'Mauritania', 'Active', NULL, NULL),
(140, 'MU', 'Mauritius', 'Active', NULL, NULL),
(141, 'TY', 'Mayotte', 'Active', NULL, NULL),
(142, 'MX', 'Mexico', 'Active', NULL, NULL),
(143, 'FM', 'Micronesia, Federated States of', 'Active', NULL, NULL),
(144, 'MD', 'Moldova, Republic of', 'Active', NULL, NULL),
(145, 'MC', 'Monaco', 'Active', NULL, NULL),
(146, 'MN', 'Mongolia', 'Active', NULL, NULL),
(147, 'ME', 'Montenegro', 'Active', NULL, NULL),
(148, 'MS', 'Montserrat', 'Active', NULL, NULL),
(149, 'MA', 'Morocco', 'Active', NULL, NULL),
(150, 'MZ', 'Mozambique', 'Active', NULL, NULL),
(151, 'MM', 'Myanmar', 'Active', NULL, NULL),
(152, 'NA', 'Namibia', 'Active', NULL, NULL),
(153, 'NR', 'Nauru', 'Active', NULL, NULL),
(154, 'NP', 'Nepal', 'Active', NULL, NULL),
(155, 'NL', 'Netherlands', 'Active', NULL, NULL),
(156, 'AN', 'Netherlands Antilles', 'Active', NULL, NULL),
(157, 'NC', 'New Caledonia', 'Active', NULL, NULL),
(158, 'NZ', 'New Zealand', 'Active', NULL, NULL),
(159, 'NI', 'Nicaragua', 'Active', NULL, NULL),
(160, 'NE', 'Niger', 'Active', NULL, NULL),
(161, 'NG', 'Nigeria', 'Active', NULL, NULL),
(162, 'NU', 'Niue', 'Active', NULL, NULL),
(163, 'NF', 'Norfolk Island', 'Active', NULL, NULL),
(164, 'MP', 'Northern Mariana Islands', 'Active', NULL, NULL),
(165, 'NO', 'Norway', 'Active', NULL, NULL),
(166, 'OM', 'Oman', 'Active', NULL, NULL),
(167, 'PK', 'Pakistan', 'Active', NULL, NULL),
(168, 'PW', 'Palau', 'Active', NULL, NULL),
(169, 'PS', 'Palestine', 'Active', NULL, NULL),
(170, 'PA', 'Panama', 'Active', NULL, NULL),
(171, 'PG', 'Papua New Guinea', 'Active', NULL, NULL),
(172, 'PY', 'Paraguay', 'Active', NULL, NULL),
(173, 'PE', 'Peru', 'Active', NULL, NULL),
(174, 'PH', 'Philippines', 'Active', NULL, NULL),
(175, 'PN', 'Pitcairn', 'Active', NULL, NULL),
(176, 'PL', 'Poland', 'Active', NULL, NULL),
(177, 'PT', 'Portugal', 'Active', NULL, NULL),
(178, 'PR', 'Puerto Rico', 'Active', NULL, NULL),
(179, 'QA', 'Qatar', 'Active', NULL, NULL),
(180, 'RE', 'Reunion', 'Active', NULL, NULL),
(181, 'RO', 'Romania', 'Active', NULL, NULL),
(182, 'RU', 'Russian Federation', 'Active', NULL, NULL),
(183, 'RW', 'Rwanda', 'Active', NULL, NULL),
(184, 'KN', 'Saint Kitts and Nevis', 'Active', NULL, NULL),
(185, 'LC', 'Saint Lucia', 'Active', NULL, NULL),
(186, 'VC', 'Saint Vincent and the Grenadines', 'Active', NULL, NULL),
(187, 'WS', 'Samoa', 'Active', NULL, NULL),
(188, 'SM', 'San Marino', 'Active', NULL, NULL),
(189, 'ST', 'Sao Tome and Principe', 'Active', NULL, NULL),
(190, 'SA', 'Saudi Arabia', 'Active', NULL, NULL),
(191, 'SN', 'Senegal', 'Active', NULL, NULL),
(192, 'RS', 'Serbia', 'Active', NULL, NULL),
(193, 'SC', 'Seychelles', 'Active', NULL, NULL),
(194, 'SL', 'Sierra Leone', 'Active', NULL, NULL),
(195, 'SG', 'Singapore', 'Active', NULL, NULL),
(196, 'SK', 'Slovakia', 'Active', NULL, NULL),
(197, 'SI', 'Slovenia', 'Active', NULL, NULL),
(198, 'SB', 'Solomon Islands', 'Active', NULL, NULL),
(199, 'SO', 'Somalia', 'Active', NULL, NULL),
(200, 'ZA', 'South Africa', 'Active', NULL, NULL),
(201, 'GS', 'South Georgia South Sandwich Islands', 'Active', NULL, NULL),
(202, 'SS', 'South Sudan', 'Active', NULL, NULL),
(203, 'ES', 'Spain', 'Active', NULL, NULL),
(204, 'LK', 'Sri Lanka', 'Active', NULL, NULL),
(205, 'SH', 'St. Helena', 'Active', NULL, NULL),
(206, 'PM', 'St. Pierre and Miquelon', 'Active', NULL, NULL),
(207, 'SD', 'Sudan', 'Active', NULL, NULL),
(208, 'SR', 'Suriname', 'Active', NULL, NULL),
(209, 'SJ', 'Svalbard and Jan Mayen Islands', 'Active', NULL, NULL),
(210, 'SZ', 'Swaziland', 'Active', NULL, NULL),
(211, 'SE', 'Sweden', 'Active', NULL, NULL),
(212, 'CH', 'Switzerland', 'Active', NULL, NULL),
(213, 'SY', 'Syrian Arab Republic', 'Active', NULL, NULL),
(214, 'TW', 'Taiwan', 'Active', NULL, NULL),
(215, 'TJ', 'Tajikistan', 'Active', NULL, NULL),
(216, 'TZ', 'Tanzania, United Republic of', 'Active', NULL, NULL),
(217, 'TH', 'Thailand', 'Active', NULL, NULL),
(218, 'TG', 'Togo', 'Active', NULL, NULL),
(219, 'TK', 'Tokelau', 'Active', NULL, NULL),
(220, 'TO', 'Tonga', 'Active', NULL, NULL),
(221, 'TT', 'Trinidad and Tobago', 'Active', NULL, NULL),
(222, 'TN', 'Tunisia', 'Active', NULL, NULL),
(223, 'TR', 'Turkey', 'Active', NULL, NULL),
(224, 'TM', 'Turkmenistan', 'Active', NULL, NULL),
(225, 'TC', 'Turks and Caicos Islands', 'Active', NULL, NULL),
(226, 'TV', 'Tuvalu', 'Active', NULL, NULL),
(227, 'UG', 'Uganda', 'Active', NULL, NULL),
(228, 'UA', 'Ukraine', 'Active', NULL, NULL),
(229, 'AE', 'United Arab Emirates', 'Active', NULL, NULL),
(230, 'GB', 'United Kingdom', 'Active', NULL, NULL),
(231, 'US', 'United States', 'Active', NULL, NULL),
(232, 'UM', 'United States minor outlying islands', 'Active', NULL, NULL),
(233, 'UY', 'Uruguay', 'Active', NULL, NULL),
(234, 'UZ', 'Uzbekistan', 'Active', NULL, NULL),
(235, 'VU', 'Vanuatu', 'Active', NULL, NULL),
(236, 'VA', 'Vatican City State', 'Active', NULL, NULL),
(237, 'VE', 'Venezuela', 'Active', NULL, NULL),
(238, 'VN', 'Vietnam', 'Active', NULL, NULL),
(239, 'VG', 'Virgin Islands (British)', 'Active', NULL, NULL),
(240, 'VI', 'Virgin Islands (U.S.)', 'Active', NULL, NULL),
(241, 'WF', 'Wallis and Futuna Islands', 'Active', NULL, NULL),
(242, 'EH', 'Western Sahara', 'Active', NULL, NULL),
(243, 'YE', 'Yemen', 'Active', NULL, NULL),
(244, 'ZR', 'Zaire', 'Active', NULL, NULL),
(245, 'ZM', 'Zambia', 'Active', NULL, NULL),
(246, 'ZW', 'Zimbabwe', 'Active', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `setup_inventory_stores`
--

CREATE TABLE `setup_inventory_stores` (
  `id` bigint UNSIGNED NOT NULL,
  `code` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_units_id` bigint UNSIGNED NOT NULL,
  `country_id` bigint UNSIGNED NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `users_id` bigint UNSIGNED NOT NULL,
  `is_active` enum('Active','InActive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `setup_inventory_stores`
--

INSERT INTO `setup_inventory_stores` (`id`, `code`, `name`, `phone`, `email`, `address`, `city`, `state`, `zip`, `business_units_id`, `country_id`, `logo`, `users_id`, `is_active`, `created_at`, `updated_at`) VALUES
(2, '0001', 'Uttara Sector-1', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 2, 18, NULL, 1, 'Active', '2024-10-08 23:32:53', '2024-10-09 00:51:41'),
(3, '0003', 'Uttara Sector-2', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 2, 18, NULL, 1, 'Active', '2024-10-09 00:52:33', '2024-10-09 00:52:33'),
(4, '0004', 'Uttara Sector-3', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 2, 18, NULL, 1, 'Active', '2024-10-09 00:53:58', '2024-10-09 00:53:58'),
(5, '0005', 'Dhanmondi-27', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 1, 18, NULL, 1, 'Active', '2024-10-09 00:54:27', '2024-10-09 00:54:27'),
(6, '0006', 'Dhanmondi-15', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 1, 18, NULL, 1, 'Active', '2024-10-09 00:55:03', '2024-10-09 00:55:03'),
(7, '0007', 'Dhanmondi-9', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 1, 18, NULL, 1, 'Active', '2024-10-09 00:56:57', '2024-10-09 00:56:57'),
(8, '0008', 'Mirpur-10', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 3, 18, NULL, 1, 'Active', '2024-10-09 00:59:41', '2024-10-09 00:59:41'),
(9, '0009', 'Mirpur-11', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 3, 18, NULL, 1, 'Active', '2024-10-09 01:00:54', '2024-10-09 01:00:54'),
(10, '0010', 'Mirpur-12', '01718899252', 'rashed.zamann@gmail.com', 'Floor: 24, City Center, Motizheel, Dhaka', 'Dhaka', 'Dhaka', '1000', 3, 18, NULL, 1, 'Active', '2024-10-09 01:01:24', '2024-10-09 01:01:24');

-- --------------------------------------------------------

--
-- Table structure for table `setup_settings`
--

CREATE TABLE `setup_settings` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `account_accounts`
--
ALTER TABLE `account_accounts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_accounts_name_accounts_level_unique` (`name`,`accounts_level`),
  ADD UNIQUE KEY `account_accounts_code_unique` (`code`),
  ADD KEY `account_accounts_parent_id_foreign` (`parent_id`),
  ADD KEY `account_accounts_name_index` (`name`),
  ADD KEY `account_accounts_accounts_level_index` (`accounts_level`),
  ADD KEY `account_accounts_is_active_index` (`is_active`);

--
-- Indexes for table `account_periods`
--
ALTER TABLE `account_periods`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_periods_code_unique` (`code`),
  ADD UNIQUE KEY `account_periods_name_unique` (`name`),
  ADD KEY `account_periods_start_date_index` (`start_date`),
  ADD KEY `account_periods_end_date_index` (`end_date`),
  ADD KEY `account_periods_open_status_index` (`open_status`);

--
-- Indexes for table `account_sub_ledger`
--
ALTER TABLE `account_sub_ledger`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_sub_ledger_code_unique` (`code`),
  ADD UNIQUE KEY `account_sub_ledger_name_unique` (`name`),
  ADD KEY `account_sub_ledger_accounts_id_foreign` (`accounts_id`),
  ADD KEY `account_sub_ledger_is_active_index` (`is_active`);

--
-- Indexes for table `account_transactions`
--
ALTER TABLE `account_transactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `account_transactions_code_unique` (`code`),
  ADD KEY `account_transactions_account_period_id_foreign` (`account_period_id`),
  ADD KEY `account_transactions_business_units_id_foreign` (`business_units_id`),
  ADD KEY `account_transactions_posting_date_index` (`posting_date`),
  ADD KEY `account_transactions_voucher_type_index` (`voucher_type`),
  ADD KEY `account_transactions_approve_status_index` (`approve_status`);

--
-- Indexes for table `account_transactions_lines`
--
ALTER TABLE `account_transactions_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `account_transactions_lines_account_transactions_id_foreign` (`account_transactions_id`),
  ADD KEY `account_transactions_lines_account_period_id_foreign` (`account_period_id`),
  ADD KEY `account_transactions_lines_accounts_id_foreign` (`accounts_id`),
  ADD KEY `account_transactions_lines_sub_ledger_id_foreign` (`sub_ledger_id`),
  ADD KEY `account_transactions_lines_business_units_id_foreign` (`business_units_id`),
  ADD KEY `account_transactions_lines_posting_date_index` (`posting_date`),
  ADD KEY `account_transactions_lines_voucher_type_index` (`voucher_type`),
  ADD KEY `account_transactions_lines_dr_cr_type_index` (`dr_cr_type`);

--
-- Indexes for table `admins`
--
ALTER TABLE `admins`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `admins_email_unique` (`email`),
  ADD KEY `admins_employee_id_foreign` (`employee_id`);

--
-- Indexes for table `cache`
--
ALTER TABLE `cache`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `cache_locks`
--
ALTER TABLE `cache_locks`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `hrm_departments`
--
ALTER TABLE `hrm_departments`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `hrm_departments_code_unique` (`code`),
  ADD KEY `hrm_departments_name_index` (`name`),
  ADD KEY `hrm_departments_is_active_index` (`is_active`);

--
-- Indexes for table `hrm_designations`
--
ALTER TABLE `hrm_designations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `hrm_designations_code_unique` (`code`),
  ADD KEY `hrm_designations_name_index` (`name`),
  ADD KEY `hrm_designations_is_active_index` (`is_active`);

--
-- Indexes for table `hrm_employees`
--
ALTER TABLE `hrm_employees`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `hrm_employees_code_unique` (`code`),
  ADD KEY `hrm_employees_country_id_foreign` (`country_id`),
  ADD KEY `hrm_employees_departments_id_foreign` (`departments_id`),
  ADD KEY `hrm_employees_designations_id_foreign` (`designations_id`),
  ADD KEY `hrm_employees_business_units_id_foreign` (`business_units_id`),
  ADD KEY `hrm_employees_inventory_store_id_foreign` (`inventory_store_id`),
  ADD KEY `hrm_employees_full_name_index` (`full_name`),
  ADD KEY `hrm_employees_is_active_index` (`is_active`);

--
-- Indexes for table `hrm_employee_business_units`
--
ALTER TABLE `hrm_employee_business_units`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hrm_employee_business_units_employee_id_foreign` (`employee_id`),
  ADD KEY `hrm_employee_business_units_business_unit_id_foreign` (`business_unit_id`);

--
-- Indexes for table `hrm_employee_contacts`
--
ALTER TABLE `hrm_employee_contacts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hrm_employee_contacts_employee_id_foreign` (`employee_id`),
  ADD KEY `hrm_employee_contacts_country_id_foreign` (`country_id`);

--
-- Indexes for table `hrm_employee_stores`
--
ALTER TABLE `hrm_employee_stores`
  ADD PRIMARY KEY (`id`),
  ADD KEY `hrm_employee_stores_employee_id_foreign` (`employee_id`),
  ADD KEY `hrm_employee_stores_store_id_foreign` (`store_id`);

--
-- Indexes for table `inventory_attributes`
--
ALTER TABLE `inventory_attributes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_item_options_code_unique` (`code`),
  ADD UNIQUE KEY `inventory_item_options_name_unique` (`name`),
  ADD KEY `inventory_item_options_is_active_index` (`is_active`);

--
-- Indexes for table `inventory_attribute_values`
--
ALTER TABLE `inventory_attribute_values`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_item_option_values_code_unique` (`code`),
  ADD KEY `inventory_item_option_values_is_active_index` (`is_active`),
  ADD KEY `inventory_item_option_values_inventory_item_option_id_foreign` (`inventory_attribute_id`);

--
-- Indexes for table `inventory_categories`
--
ALTER TABLE `inventory_categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_categories_code_unique` (`code`),
  ADD UNIQUE KEY `inventory_categories_url_unique` (`url`),
  ADD KEY `inventory_categories_parent_id_foreign` (`parent_id`),
  ADD KEY `inventory_categories_category_level_index` (`category_level`),
  ADD KEY `inventory_categories_is_active_index` (`is_active`);

--
-- Indexes for table `inventory_items`
--
ALTER TABLE `inventory_items`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_items_code_unique` (`code`),
  ADD KEY `inventory_items_category_id_foreign` (`category_id`),
  ADD KEY `inventory_items_brand_id_foreign` (`brand_id`),
  ADD KEY `inventory_items_taxes_id_foreign` (`taxes_id`),
  ADD KEY `inventory_items_published_index` (`published`),
  ADD KEY `inventory_items_code_index` (`code`),
  ADD KEY `inventory_items_slug_index` (`slug`);

--
-- Indexes for table `inventory_item_attributes`
--
ALTER TABLE `inventory_item_attributes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inventory_item_attributes_inventory_attribute_id_fk` (`inventory_attribute_id`),
  ADD KEY `inventory_item_id` (`inventory_item_id`,`inventory_attribute_id`);

--
-- Indexes for table `inventory_item_brands`
--
ALTER TABLE `inventory_item_brands`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_item_brands_code_unique` (`code`),
  ADD UNIQUE KEY `inventory_item_brands_name_unique` (`name`),
  ADD KEY `inventory_item_brands_is_active_index` (`is_active`);

--
-- Indexes for table `inventory_item_requisitions`
--
ALTER TABLE `inventory_item_requisitions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_item_requisitions_code_unique` (`code`),
  ADD KEY `inventory_item_requisitions_departments_id_foreign` (`departments_id`),
  ADD KEY `inventory_item_requisitions_business_units_id_foreign` (`business_units_id`),
  ADD KEY `inventory_item_requisitions_transaction_date_index` (`transaction_date`),
  ADD KEY `inventory_item_requisitions_requisition_status_index` (`requisition_status`),
  ADD KEY `inventory_item_requisitions_approve_status_index` (`approve_status`);

--
-- Indexes for table `inventory_item_requisition_lines`
--
ALTER TABLE `inventory_item_requisition_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inventory_item_requisition_lines_item_requisition_id_foreign` (`item_requisition_id`),
  ADD KEY `inventory_item_requisition_lines_item_id_foreign` (`item_id`),
  ADD KEY `inventory_item_requisition_lines_unit_id_foreign` (`unit_id`);

--
-- Indexes for table `inventory_item_skus`
--
ALTER TABLE `inventory_item_skus`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sku` (`sku`),
  ADD KEY `inventory_item_variants_inventory_item_id_foreign` (`inventory_item_id`),
  ADD KEY `inventory_item_variants_is_active_index` (`is_active`);

--
-- Indexes for table `inventory_item_sku_attribute_values`
--
ALTER TABLE `inventory_item_sku_attribute_values`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inventory_item_sku_attribute_values.inventory_attribute_id_fk` (`inventory_attribute_id`),
  ADD KEY `inventory_item_sku_attribute_values.inventory_attribute_value_id` (`inventory_attribute_value_id`),
  ADD KEY `inventory_item_sku_id` (`inventory_item_sku_id`,`inventory_attribute_id`,`inventory_attribute_value_id`);

--
-- Indexes for table `inventory_item_taxes`
--
ALTER TABLE `inventory_item_taxes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_item_taxes_code_unique` (`code`),
  ADD UNIQUE KEY `inventory_item_taxes_name_unique` (`name`),
  ADD KEY `inventory_item_taxes_is_active_index` (`is_active`);

--
-- Indexes for table `inventory_item_transactions`
--
ALTER TABLE `inventory_item_transactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_item_transactions_code_unique` (`code`),
  ADD KEY `inventory_item_transactions_sales_order_id_foreign` (`sales_order_id`),
  ADD KEY `inventory_item_transactions_purchase_order_id_foreign` (`purchase_order_id`),
  ADD KEY `inventory_item_transactions_item_requisition_id_foreign` (`item_requisition_id`),
  ADD KEY `inventory_item_transactions_inventory_periods_id_foreign` (`inventory_periods_id`),
  ADD KEY `inventory_item_transactions_inventory_store_id_foreign` (`inventory_store_id`),
  ADD KEY `inventory_item_transactions_transaction_date_index` (`transaction_date`),
  ADD KEY `inventory_item_transactions_transaction_type_index` (`transaction_type`),
  ADD KEY `inventory_item_transactions_approve_status_index` (`approve_status`);

--
-- Indexes for table `inventory_item_transaction_lines`
--
ALTER TABLE `inventory_item_transaction_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `inventory_item_transaction_lines_transaction_id_foreign` (`transaction_id`),
  ADD KEY `inventory_item_transaction_lines_sales_line_id_foreign` (`sales_line_id`),
  ADD KEY `inventory_item_transaction_lines_purchase_line_id_foreign` (`purchase_line_id`),
  ADD KEY `inventory_item_transaction_lines_requisition_line_id_foreign` (`requisition_line_id`),
  ADD KEY `inventory_item_transaction_lines_period_id_foreign` (`period_id`),
  ADD KEY `inventory_item_transaction_lines_item_id_foreign` (`item_id`),
  ADD KEY `inventory_item_transaction_lines_unit_id_foreign` (`unit_id`),
  ADD KEY `inventory_item_transaction_lines_transaction_date_index` (`transaction_date`),
  ADD KEY `inventory_item_transaction_lines_transaction_type_index` (`transaction_type`),
  ADD KEY `inventory_item_transaction_lines_transaction_mode_index` (`transaction_mode`);

--
-- Indexes for table `inventory_periods`
--
ALTER TABLE `inventory_periods`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_periods_code_unique` (`code`),
  ADD UNIQUE KEY `inventory_periods_name_unique` (`name`),
  ADD KEY `inventory_periods_start_date_index` (`start_date`),
  ADD KEY `inventory_periods_end_date_index` (`end_date`),
  ADD KEY `inventory_periods_open_status_index` (`open_status`);

--
-- Indexes for table `inventory_units`
--
ALTER TABLE `inventory_units`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `inventory_units_code_unique` (`code`),
  ADD UNIQUE KEY `inventory_units_name_unique` (`name`),
  ADD KEY `inventory_units_is_active_index` (`is_active`);

--
-- Indexes for table `jobs`
--
ALTER TABLE `jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jobs_queue_index` (`queue`);

--
-- Indexes for table `job_batches`
--
ALTER TABLE `job_batches`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `purchase_item_requisitions`
--
ALTER TABLE `purchase_item_requisitions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `purchase_item_requisitions_code_unique` (`code`),
  ADD KEY `purchase_item_requisitions_item_requisition_id_foreign` (`item_requisition_id`),
  ADD KEY `purchase_item_requisitions_departments_id_foreign` (`departments_id`),
  ADD KEY `purchase_item_requisitions_business_units_id_foreign` (`business_units_id`),
  ADD KEY `purchase_item_requisitions_transaction_date_index` (`transaction_date`),
  ADD KEY `purchase_item_requisitions_requisition_status_index` (`requisition_status`),
  ADD KEY `purchase_item_requisitions_approve_status_index` (`approve_status`);

--
-- Indexes for table `purchase_item_requisition_lines`
--
ALTER TABLE `purchase_item_requisition_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `purchase_item_requisition_lines_item_requisition_id_foreign` (`item_requisition_id`),
  ADD KEY `purchase_item_requisition_lines_item_requisition_line_id_foreign` (`item_requisition_line_id`),
  ADD KEY `purchase_item_requisition_lines_item_id_foreign` (`item_id`),
  ADD KEY `purchase_item_requisition_lines_unit_id_foreign` (`unit_id`);

--
-- Indexes for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `purchase_orders_code_unique` (`code`),
  ADD KEY `purchase_orders_supplier_id_foreign` (`supplier_id`),
  ADD KEY `purchase_orders_item_requisition_id_foreign` (`item_requisition_id`),
  ADD KEY `purchase_orders_business_units_id_foreign` (`business_units_id`),
  ADD KEY `purchase_orders_transaction_date_index` (`transaction_date`),
  ADD KEY `purchase_orders_purchase_status_index` (`purchase_status`),
  ADD KEY `purchase_orders_approve_status_index` (`approve_status`);

--
-- Indexes for table `purchase_order_lines`
--
ALTER TABLE `purchase_order_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `purchase_order_lines_purchase_order_id_foreign` (`purchase_order_id`),
  ADD KEY `purchase_order_lines_item_requisition_line_id_foreign` (`item_requisition_line_id`),
  ADD KEY `purchase_order_lines_item_id_foreign` (`item_id`),
  ADD KEY `purchase_order_lines_unit_id_foreign` (`unit_id`);

--
-- Indexes for table `purchase_suppliers`
--
ALTER TABLE `purchase_suppliers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `purchase_suppliers_code_unique` (`code`),
  ADD UNIQUE KEY `purchase_suppliers_name_unique` (`name`),
  ADD KEY `purchase_suppliers_country_id_foreign` (`country_id`),
  ADD KEY `purchase_suppliers_is_active_index` (`is_active`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Indexes for table `sales_billing_addresses`
--
ALTER TABLE `sales_billing_addresses`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sales_billing_addresses_code_unique` (`code`),
  ADD KEY `sales_billing_addresses_sales_order_id_foreign` (`sales_order_id`),
  ADD KEY `sales_billing_addresses_setup_country_foreign` (`setup_country`),
  ADD KEY `sales_billing_addresses_is_active_index` (`is_active`);

--
-- Indexes for table `sales_customers`
--
ALTER TABLE `sales_customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sales_customers_code_unique` (`code`),
  ADD KEY `sales_customers_admin_id_foreign` (`admin_id`),
  ADD KEY `sales_customers_setup_country_id_index` (`setup_country_id`),
  ADD KEY `sales_customers_is_active_index` (`is_active`);

--
-- Indexes for table `sales_customer_billing_addresses`
--
ALTER TABLE `sales_customer_billing_addresses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sales_customer_billing_addresses_sales_customer_id_foreign` (`sales_customer_id`),
  ADD KEY `sales_customer_billing_addresses_setup_country_foreign` (`setup_country`);

--
-- Indexes for table `sales_customer_shipping_addresses`
--
ALTER TABLE `sales_customer_shipping_addresses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sales_customer_shipping_addresses_sales_customer_id_foreign` (`sales_customer_id`),
  ADD KEY `sales_customer_shipping_addresses_setup_country_foreign` (`setup_country`);

--
-- Indexes for table `sales_orders`
--
ALTER TABLE `sales_orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sales_orders_code_unique` (`code`),
  ADD KEY `sales_orders_sales_quotation_id_foreign` (`sales_quotation_id`),
  ADD KEY `sales_orders_customer_id_foreign` (`customer_id`),
  ADD KEY `sales_orders_business_units_id_foreign` (`business_units_id`),
  ADD KEY `sales_orders_transaction_date_index` (`transaction_date`),
  ADD KEY `sales_orders_sales_status_index` (`sales_status`),
  ADD KEY `sales_orders_approve_status_index` (`approve_status`);

--
-- Indexes for table `sales_order_lines`
--
ALTER TABLE `sales_order_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sales_order_lines_sales_order_id_foreign` (`sales_order_id`),
  ADD KEY `sales_order_lines_sales_quotation_line_id_foreign` (`sales_quotation_line_id`),
  ADD KEY `sales_order_lines_item_id_foreign` (`item_id`),
  ADD KEY `sales_order_lines_unit_id_foreign` (`unit_id`);

--
-- Indexes for table `sales_quotations`
--
ALTER TABLE `sales_quotations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sales_quotations_code_unique` (`code`),
  ADD KEY `sales_quotations_customer_id_foreign` (`customer_id`),
  ADD KEY `sales_quotations_business_units_id_foreign` (`business_units_id`),
  ADD KEY `sales_quotations_transaction_date_index` (`transaction_date`),
  ADD KEY `sales_quotations_sales_status_index` (`sales_status`),
  ADD KEY `sales_quotations_approve_status_index` (`approve_status`);

--
-- Indexes for table `sales_quotation_lines`
--
ALTER TABLE `sales_quotation_lines`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sales_quotation_lines_sales_quotation_id_foreign` (`sales_quotation_id`),
  ADD KEY `sales_quotation_lines_item_id_foreign` (`item_id`),
  ADD KEY `sales_quotation_lines_unit_id_foreign` (`unit_id`);

--
-- Indexes for table `sales_shipping_addresses`
--
ALTER TABLE `sales_shipping_addresses`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `sales_shipping_addresses_code_unique` (`code`),
  ADD KEY `sales_shipping_addresses_sales_order_id_foreign` (`sales_order_id`),
  ADD KEY `sales_shipping_addresses_setup_country_foreign` (`setup_country`),
  ADD KEY `sales_shipping_addresses_is_active_index` (`is_active`);

--
-- Indexes for table `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sessions_user_id_index` (`user_id`),
  ADD KEY `sessions_last_activity_index` (`last_activity`);

--
-- Indexes for table `setup_business_units`
--
ALTER TABLE `setup_business_units`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setup_business_units_code_unique` (`code`),
  ADD UNIQUE KEY `setup_business_units_name_unique` (`name`),
  ADD KEY `setup_business_units_companies_id_foreign` (`companies_id`),
  ADD KEY `setup_business_units_country_id_foreign` (`country_id`),
  ADD KEY `setup_business_units_users_id_foreign` (`users_id`),
  ADD KEY `setup_business_units_is_active_index` (`is_active`);

--
-- Indexes for table `setup_companies`
--
ALTER TABLE `setup_companies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setup_companies_code_unique` (`code`),
  ADD UNIQUE KEY `setup_companies_name_unique` (`name`),
  ADD KEY `setup_companies_country_id_foreign` (`country_id`),
  ADD KEY `setup_companies_is_active_index` (`is_active`);

--
-- Indexes for table `setup_countries`
--
ALTER TABLE `setup_countries`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setup_countries_code_unique` (`code`),
  ADD UNIQUE KEY `setup_countries_name_unique` (`name`),
  ADD KEY `setup_countries_is_active_index` (`is_active`);

--
-- Indexes for table `setup_inventory_stores`
--
ALTER TABLE `setup_inventory_stores`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setup_inventory_stores_code_unique` (`code`),
  ADD UNIQUE KEY `setup_inventory_stores_name_unique` (`name`),
  ADD KEY `setup_inventory_stores_business_units_id_foreign` (`business_units_id`),
  ADD KEY `setup_inventory_stores_country_id_foreign` (`country_id`),
  ADD KEY `setup_inventory_stores_users_id_foreign` (`users_id`),
  ADD KEY `setup_inventory_stores_is_active_index` (`is_active`);

--
-- Indexes for table `setup_settings`
--
ALTER TABLE `setup_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setup_settings_name_unique` (`name`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `account_accounts`
--
ALTER TABLE `account_accounts`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `account_periods`
--
ALTER TABLE `account_periods`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `account_sub_ledger`
--
ALTER TABLE `account_sub_ledger`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `account_transactions`
--
ALTER TABLE `account_transactions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `account_transactions_lines`
--
ALTER TABLE `account_transactions_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `admins`
--
ALTER TABLE `admins`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hrm_departments`
--
ALTER TABLE `hrm_departments`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hrm_designations`
--
ALTER TABLE `hrm_designations`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hrm_employees`
--
ALTER TABLE `hrm_employees`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `hrm_employee_business_units`
--
ALTER TABLE `hrm_employee_business_units`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `hrm_employee_contacts`
--
ALTER TABLE `hrm_employee_contacts`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hrm_employee_stores`
--
ALTER TABLE `hrm_employee_stores`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `inventory_attributes`
--
ALTER TABLE `inventory_attributes`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `inventory_attribute_values`
--
ALTER TABLE `inventory_attribute_values`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `inventory_categories`
--
ALTER TABLE `inventory_categories`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=36;

--
-- AUTO_INCREMENT for table `inventory_items`
--
ALTER TABLE `inventory_items`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `inventory_item_attributes`
--
ALTER TABLE `inventory_item_attributes`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `inventory_item_brands`
--
ALTER TABLE `inventory_item_brands`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `inventory_item_requisitions`
--
ALTER TABLE `inventory_item_requisitions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inventory_item_requisition_lines`
--
ALTER TABLE `inventory_item_requisition_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inventory_item_skus`
--
ALTER TABLE `inventory_item_skus`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `inventory_item_sku_attribute_values`
--
ALTER TABLE `inventory_item_sku_attribute_values`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=249;

--
-- AUTO_INCREMENT for table `inventory_item_taxes`
--
ALTER TABLE `inventory_item_taxes`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `inventory_item_transactions`
--
ALTER TABLE `inventory_item_transactions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inventory_item_transaction_lines`
--
ALTER TABLE `inventory_item_transaction_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inventory_periods`
--
ALTER TABLE `inventory_periods`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inventory_units`
--
ALTER TABLE `inventory_units`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `jobs`
--
ALTER TABLE `jobs`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `purchase_item_requisitions`
--
ALTER TABLE `purchase_item_requisitions`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase_item_requisition_lines`
--
ALTER TABLE `purchase_item_requisition_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase_order_lines`
--
ALTER TABLE `purchase_order_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase_suppliers`
--
ALTER TABLE `purchase_suppliers`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `sales_billing_addresses`
--
ALTER TABLE `sales_billing_addresses`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_customers`
--
ALTER TABLE `sales_customers`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_customer_billing_addresses`
--
ALTER TABLE `sales_customer_billing_addresses`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_customer_shipping_addresses`
--
ALTER TABLE `sales_customer_shipping_addresses`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_orders`
--
ALTER TABLE `sales_orders`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_order_lines`
--
ALTER TABLE `sales_order_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_quotations`
--
ALTER TABLE `sales_quotations`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_quotation_lines`
--
ALTER TABLE `sales_quotation_lines`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `sales_shipping_addresses`
--
ALTER TABLE `sales_shipping_addresses`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `setup_business_units`
--
ALTER TABLE `setup_business_units`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `setup_companies`
--
ALTER TABLE `setup_companies`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `setup_countries`
--
ALTER TABLE `setup_countries`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=247;

--
-- AUTO_INCREMENT for table `setup_inventory_stores`
--
ALTER TABLE `setup_inventory_stores`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `setup_settings`
--
ALTER TABLE `setup_settings`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `account_accounts`
--
ALTER TABLE `account_accounts`
  ADD CONSTRAINT `account_accounts_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `account_accounts` (`id`);

--
-- Constraints for table `account_sub_ledger`
--
ALTER TABLE `account_sub_ledger`
  ADD CONSTRAINT `account_sub_ledger_accounts_id_foreign` FOREIGN KEY (`accounts_id`) REFERENCES `account_accounts` (`id`);

--
-- Constraints for table `account_transactions`
--
ALTER TABLE `account_transactions`
  ADD CONSTRAINT `account_transactions_account_period_id_foreign` FOREIGN KEY (`account_period_id`) REFERENCES `account_periods` (`id`),
  ADD CONSTRAINT `account_transactions_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`);

--
-- Constraints for table `account_transactions_lines`
--
ALTER TABLE `account_transactions_lines`
  ADD CONSTRAINT `account_transactions_lines_account_period_id_foreign` FOREIGN KEY (`account_period_id`) REFERENCES `account_periods` (`id`),
  ADD CONSTRAINT `account_transactions_lines_account_transactions_id_foreign` FOREIGN KEY (`account_transactions_id`) REFERENCES `account_transactions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `account_transactions_lines_accounts_id_foreign` FOREIGN KEY (`accounts_id`) REFERENCES `account_accounts` (`id`),
  ADD CONSTRAINT `account_transactions_lines_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `account_transactions_lines_sub_ledger_id_foreign` FOREIGN KEY (`sub_ledger_id`) REFERENCES `account_sub_ledger` (`id`);

--
-- Constraints for table `admins`
--
ALTER TABLE `admins`
  ADD CONSTRAINT `admins_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `hrm_employees` (`id`);

--
-- Constraints for table `hrm_employees`
--
ALTER TABLE `hrm_employees`
  ADD CONSTRAINT `hrm_employees_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `hrm_employees_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `setup_countries` (`id`),
  ADD CONSTRAINT `hrm_employees_departments_id_foreign` FOREIGN KEY (`departments_id`) REFERENCES `hrm_departments` (`id`),
  ADD CONSTRAINT `hrm_employees_designations_id_foreign` FOREIGN KEY (`designations_id`) REFERENCES `hrm_designations` (`id`),
  ADD CONSTRAINT `hrm_employees_inventory_store_id_foreign` FOREIGN KEY (`inventory_store_id`) REFERENCES `setup_inventory_stores` (`id`);

--
-- Constraints for table `hrm_employee_business_units`
--
ALTER TABLE `hrm_employee_business_units`
  ADD CONSTRAINT `hrm_employee_business_units_business_unit_id_foreign` FOREIGN KEY (`business_unit_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `hrm_employee_business_units_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `hrm_employees` (`id`);

--
-- Constraints for table `hrm_employee_contacts`
--
ALTER TABLE `hrm_employee_contacts`
  ADD CONSTRAINT `hrm_employee_contacts_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `setup_countries` (`id`),
  ADD CONSTRAINT `hrm_employee_contacts_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `hrm_employees` (`id`);

--
-- Constraints for table `hrm_employee_stores`
--
ALTER TABLE `hrm_employee_stores`
  ADD CONSTRAINT `hrm_employee_stores_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `hrm_employees` (`id`),
  ADD CONSTRAINT `hrm_employee_stores_store_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `setup_inventory_stores` (`id`);

--
-- Constraints for table `inventory_attribute_values`
--
ALTER TABLE `inventory_attribute_values`
  ADD CONSTRAINT `inventory_item_option_values_inventory_item_option_id_foreign` FOREIGN KEY (`inventory_attribute_id`) REFERENCES `inventory_attributes` (`id`);

--
-- Constraints for table `inventory_categories`
--
ALTER TABLE `inventory_categories`
  ADD CONSTRAINT `inventory_categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `inventory_categories` (`id`);

--
-- Constraints for table `inventory_items`
--
ALTER TABLE `inventory_items`
  ADD CONSTRAINT `inventory_items_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `inventory_item_brands` (`id`),
  ADD CONSTRAINT `inventory_items_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `inventory_categories` (`id`),
  ADD CONSTRAINT `inventory_items_taxes_id_foreign` FOREIGN KEY (`taxes_id`) REFERENCES `inventory_item_taxes` (`id`);

--
-- Constraints for table `inventory_item_attributes`
--
ALTER TABLE `inventory_item_attributes`
  ADD CONSTRAINT `inventory_item_attributes_inventory_attribute_id_fk` FOREIGN KEY (`inventory_attribute_id`) REFERENCES `inventory_attributes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `inventory_item_attributes_inventory_item_id_fk` FOREIGN KEY (`inventory_item_id`) REFERENCES `inventory_items` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Constraints for table `inventory_item_requisitions`
--
ALTER TABLE `inventory_item_requisitions`
  ADD CONSTRAINT `inventory_item_requisitions_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `inventory_item_requisitions_departments_id_foreign` FOREIGN KEY (`departments_id`) REFERENCES `hrm_departments` (`id`);

--
-- Constraints for table `inventory_item_requisition_lines`
--
ALTER TABLE `inventory_item_requisition_lines`
  ADD CONSTRAINT `inventory_item_requisition_lines_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `inventory_items` (`id`),
  ADD CONSTRAINT `inventory_item_requisition_lines_item_requisition_id_foreign` FOREIGN KEY (`item_requisition_id`) REFERENCES `inventory_item_requisitions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `inventory_item_requisition_lines_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `inventory_units` (`id`);

--
-- Constraints for table `inventory_item_skus`
--
ALTER TABLE `inventory_item_skus`
  ADD CONSTRAINT `inventory_item_variants_inventory_item_id_foreign` FOREIGN KEY (`inventory_item_id`) REFERENCES `inventory_items` (`id`);

--
-- Constraints for table `inventory_item_sku_attribute_values`
--
ALTER TABLE `inventory_item_sku_attribute_values`
  ADD CONSTRAINT `inventory_item_sku_attribute_values.inventory_attribute_id_fk` FOREIGN KEY (`inventory_attribute_id`) REFERENCES `inventory_attributes` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `inventory_item_sku_attribute_values.inventory_attribute_value_id` FOREIGN KEY (`inventory_attribute_value_id`) REFERENCES `inventory_attribute_values` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `inventory_item_sku_attribute_values_inventory_item_sku_id_fk` FOREIGN KEY (`inventory_item_sku_id`) REFERENCES `inventory_item_skus` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Constraints for table `inventory_item_transactions`
--
ALTER TABLE `inventory_item_transactions`
  ADD CONSTRAINT `inventory_item_transactions_inventory_periods_id_foreign` FOREIGN KEY (`inventory_periods_id`) REFERENCES `inventory_periods` (`id`),
  ADD CONSTRAINT `inventory_item_transactions_inventory_store_id_foreign` FOREIGN KEY (`inventory_store_id`) REFERENCES `setup_inventory_stores` (`id`),
  ADD CONSTRAINT `inventory_item_transactions_item_requisition_id_foreign` FOREIGN KEY (`item_requisition_id`) REFERENCES `inventory_item_requisitions` (`id`),
  ADD CONSTRAINT `inventory_item_transactions_purchase_order_id_foreign` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`),
  ADD CONSTRAINT `inventory_item_transactions_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`);

--
-- Constraints for table `inventory_item_transaction_lines`
--
ALTER TABLE `inventory_item_transaction_lines`
  ADD CONSTRAINT `inventory_item_transaction_lines_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `inventory_items` (`id`),
  ADD CONSTRAINT `inventory_item_transaction_lines_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `inventory_periods` (`id`),
  ADD CONSTRAINT `inventory_item_transaction_lines_purchase_line_id_foreign` FOREIGN KEY (`purchase_line_id`) REFERENCES `purchase_order_lines` (`id`),
  ADD CONSTRAINT `inventory_item_transaction_lines_requisition_line_id_foreign` FOREIGN KEY (`requisition_line_id`) REFERENCES `inventory_item_requisition_lines` (`id`),
  ADD CONSTRAINT `inventory_item_transaction_lines_sales_line_id_foreign` FOREIGN KEY (`sales_line_id`) REFERENCES `sales_order_lines` (`id`),
  ADD CONSTRAINT `inventory_item_transaction_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `inventory_item_transactions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `inventory_item_transaction_lines_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `inventory_units` (`id`);

--
-- Constraints for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `purchase_item_requisitions`
--
ALTER TABLE `purchase_item_requisitions`
  ADD CONSTRAINT `purchase_item_requisitions_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `purchase_item_requisitions_departments_id_foreign` FOREIGN KEY (`departments_id`) REFERENCES `hrm_departments` (`id`),
  ADD CONSTRAINT `purchase_item_requisitions_item_requisition_id_foreign` FOREIGN KEY (`item_requisition_id`) REFERENCES `inventory_item_requisitions` (`id`);

--
-- Constraints for table `purchase_item_requisition_lines`
--
ALTER TABLE `purchase_item_requisition_lines`
  ADD CONSTRAINT `purchase_item_requisition_lines_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `inventory_items` (`id`),
  ADD CONSTRAINT `purchase_item_requisition_lines_item_requisition_id_foreign` FOREIGN KEY (`item_requisition_id`) REFERENCES `purchase_item_requisitions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `purchase_item_requisition_lines_item_requisition_line_id_foreign` FOREIGN KEY (`item_requisition_line_id`) REFERENCES `inventory_item_requisition_lines` (`id`),
  ADD CONSTRAINT `purchase_item_requisition_lines_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `inventory_units` (`id`);

--
-- Constraints for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD CONSTRAINT `purchase_orders_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `purchase_orders_item_requisition_id_foreign` FOREIGN KEY (`item_requisition_id`) REFERENCES `purchase_item_requisitions` (`id`),
  ADD CONSTRAINT `purchase_orders_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `purchase_suppliers` (`id`);

--
-- Constraints for table `purchase_order_lines`
--
ALTER TABLE `purchase_order_lines`
  ADD CONSTRAINT `purchase_order_lines_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `inventory_items` (`id`),
  ADD CONSTRAINT `purchase_order_lines_item_requisition_line_id_foreign` FOREIGN KEY (`item_requisition_line_id`) REFERENCES `purchase_item_requisition_lines` (`id`),
  ADD CONSTRAINT `purchase_order_lines_purchase_order_id_foreign` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `purchase_order_lines_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `inventory_units` (`id`);

--
-- Constraints for table `purchase_suppliers`
--
ALTER TABLE `purchase_suppliers`
  ADD CONSTRAINT `purchase_suppliers_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `setup_countries` (`id`);

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `sales_billing_addresses`
--
ALTER TABLE `sales_billing_addresses`
  ADD CONSTRAINT `sales_billing_addresses_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `sales_billing_addresses_setup_country_foreign` FOREIGN KEY (`setup_country`) REFERENCES `setup_countries` (`id`);

--
-- Constraints for table `sales_customers`
--
ALTER TABLE `sales_customers`
  ADD CONSTRAINT `sales_customers_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`);

--
-- Constraints for table `sales_customer_billing_addresses`
--
ALTER TABLE `sales_customer_billing_addresses`
  ADD CONSTRAINT `sales_customer_billing_addresses_sales_customer_id_foreign` FOREIGN KEY (`sales_customer_id`) REFERENCES `sales_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `sales_customer_billing_addresses_setup_country_foreign` FOREIGN KEY (`setup_country`) REFERENCES `setup_countries` (`id`);

--
-- Constraints for table `sales_customer_shipping_addresses`
--
ALTER TABLE `sales_customer_shipping_addresses`
  ADD CONSTRAINT `sales_customer_shipping_addresses_sales_customer_id_foreign` FOREIGN KEY (`sales_customer_id`) REFERENCES `sales_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `sales_customer_shipping_addresses_setup_country_foreign` FOREIGN KEY (`setup_country`) REFERENCES `setup_countries` (`id`);

--
-- Constraints for table `sales_orders`
--
ALTER TABLE `sales_orders`
  ADD CONSTRAINT `sales_orders_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `sales_orders_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `sales_customers` (`id`),
  ADD CONSTRAINT `sales_orders_sales_quotation_id_foreign` FOREIGN KEY (`sales_quotation_id`) REFERENCES `sales_quotations` (`id`);

--
-- Constraints for table `sales_order_lines`
--
ALTER TABLE `sales_order_lines`
  ADD CONSTRAINT `sales_order_lines_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `inventory_items` (`id`),
  ADD CONSTRAINT `sales_order_lines_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sales_order_lines_sales_quotation_line_id_foreign` FOREIGN KEY (`sales_quotation_line_id`) REFERENCES `sales_quotation_lines` (`id`),
  ADD CONSTRAINT `sales_order_lines_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `inventory_units` (`id`);

--
-- Constraints for table `sales_quotations`
--
ALTER TABLE `sales_quotations`
  ADD CONSTRAINT `sales_quotations_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `sales_quotations_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `sales_customers` (`id`);

--
-- Constraints for table `sales_quotation_lines`
--
ALTER TABLE `sales_quotation_lines`
  ADD CONSTRAINT `sales_quotation_lines_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `inventory_items` (`id`),
  ADD CONSTRAINT `sales_quotation_lines_sales_quotation_id_foreign` FOREIGN KEY (`sales_quotation_id`) REFERENCES `sales_quotations` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sales_quotation_lines_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `inventory_units` (`id`);

--
-- Constraints for table `sales_shipping_addresses`
--
ALTER TABLE `sales_shipping_addresses`
  ADD CONSTRAINT `sales_shipping_addresses_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `sales_shipping_addresses_setup_country_foreign` FOREIGN KEY (`setup_country`) REFERENCES `setup_countries` (`id`);

--
-- Constraints for table `setup_business_units`
--
ALTER TABLE `setup_business_units`
  ADD CONSTRAINT `setup_business_units_companies_id_foreign` FOREIGN KEY (`companies_id`) REFERENCES `setup_companies` (`id`),
  ADD CONSTRAINT `setup_business_units_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `setup_countries` (`id`),
  ADD CONSTRAINT `setup_business_units_users_id_foreign` FOREIGN KEY (`users_id`) REFERENCES `admins` (`id`);

--
-- Constraints for table `setup_companies`
--
ALTER TABLE `setup_companies`
  ADD CONSTRAINT `setup_companies_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `setup_countries` (`id`);

--
-- Constraints for table `setup_inventory_stores`
--
ALTER TABLE `setup_inventory_stores`
  ADD CONSTRAINT `setup_inventory_stores_business_units_id_foreign` FOREIGN KEY (`business_units_id`) REFERENCES `setup_business_units` (`id`),
  ADD CONSTRAINT `setup_inventory_stores_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `setup_countries` (`id`),
  ADD CONSTRAINT `setup_inventory_stores_users_id_foreign` FOREIGN KEY (`users_id`) REFERENCES `admins` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
