<?php

namespace App\Helpers;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class FileUploadHelper
{
    /**
     * Upload an image file safely and return the filename.
     *
     * @param  \Illuminate\Http\UploadedFile  $file
     * @param  string  $directory
     * @param  string|null  $disk
     * @return string
     */
    public static function uploadImage(UploadedFile $file, string $directory = 'uploads/products', string $disk = 'public')
    {
        $originalName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $safeName = Str::slug($originalName);
        $extension = strtolower($file->getClientOriginalExtension());
        $filename = $safeName . '_' . time() . '.' . $extension;

        // Save the file
        $file->storeAs($directory, $filename, $disk);

        // Return only the filename
        return $filename;
    }
}

