<?php

namespace App\Http\Controllers\Admin;

use App\Enums\AdminsEnum;
use App\Http\Controllers\Controller;
use Illuminate\Http;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Http\Request;
use Illuminate\Foundation\Validation;
use App\Models\Admin;
use Illuminate\Support\Facades\Hash;
use session;
use Illuminate\Support\Facades\DB;

class AdminsController extends Controller
{

    public function index()
    {
        $admins = Admin::all();
        return view('admin.user.index',compact('admins'));
    }

    public function create()
    {
        $roles = Role::all();
        //$departments = DB::table('department')->get();
        return view('admin.user.create',compact('roles'));
    }


    public function store(Request $request)
    {

        //Validate Data
        $request->validate([
            'name' => 'required|max:50',
            'email' => 'required|max:100|email|unique:admins',
            'password' => 'required|min:6|confirmed',
            'profile_picture' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        // Create New Admin
        $admin = new Admin();
        $admin->name = $request->name;
        $admin->email = $request->email;
        $admin->user_type = AdminsEnum::SYSTEM_USER;
        $admin->password = Hash::make($request->password);

        if($request->hasFile('profile_picture')){
            $name = $request->file('profile_picture')->getClientOriginalName();
            $file_info = pathinfo($name);
            $filename = $file_info['filename'].'-'.time().'.'.$file_info['extension'];

            $file = $request->file('profile_picture');
            $file->move('uploads/employee/',$filename );
            $admin->avatar = $filename;
        }else{
            $admin->avatar = '';
        }

        $admin->save();
        $id = $admin->id;

        if ($request->selectedRole) {
            $admin->assignRole($request->selectedRole);
        }


        session()->flash('success', 'Admin has been created !!');
        return redirect()->route('admin.admins.index');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $admin = Admin::find($id);
        $roles  = Role::all();
        return view('admin.user.edit', compact('admin', 'roles'));
    }

    public function deleteAvatar($id)
    {
        $admin = Admin::find($id);

        $avatar = 'uploads/employee/'.$admin->avatar;
        if (is_file($avatar)) {
            unlink($avatar);
            $admin->avatar = '';
            $admin->save();
        };

        return back();

    }

    public function update(Request $request, $id)
    {
        // Create New Admin
        $admin = Admin::find($id);

        // Validation Data
        $rules = [
            'name' => 'required|max:50',
            'password' => 'nullable|min:6|confirmed',
            'profile_picture' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
        ];
        if ($admin->user_type == AdminsEnum::SYSTEM_USER) {
            $rules['email'] = 'max:100|email|unique:admins,email,' . $id;
        }else{
            $rules['username'] = 'max:100|unique:admins,username,' . $id;
        }

        $request->validate($rules);

        $admin->name = $request->name;
        if ($admin->user_type == AdminsEnum::SYSTEM_USER) {
            $admin->email = $request->email;
        }else{
            $admin->username = $request->username;
        }
        if ($request->password) {
            $admin->password = Hash::make($request->password);
        }

        if($request->hasFile('profile_picture')){
            $name = $request->file('profile_picture')->getClientOriginalName();
            $file_info = pathinfo($name);
            $filename = $file_info['filename'].'-'.time().'.'.$file_info['extension'];

            $file = $request->file('profile_picture');
            $file->move('upload/employee/',$filename );
            $admin->avatar = $filename;
        }

        $admin->save();

        $admin->roles()->detach();
        if ($request->selectedRole) {
            $admin->assignRole($request->selectedRole);
        }


        session()->flash('success', 'Admin has been updated !!');
        return back();
    }


    public function destroy($id)
    {
        $admin = Admin::find($id);
        if (!is_null($admin)) {
            $admin->delete();
        }

        session()->flash('success', 'Admin has been deleted !!');
        return back();
    }
}
