<?php

namespace App\Http\Controllers\Admin\Hrm;

use App\Enums\AdminsEnum;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Business\SetupBusinessUnit;
use App\Models\Business\SetupInventoryStore;
use App\Models\Hrm\HrmEmployeeStore;
use Illuminate\Http\Request;

use App\Models\Hrm\HrmEmployee;
use App\Models\Hrm\HrmEmployeeContact;
use App\Http\Requests\Hrm\NewEmployeeFormRequest;
use App\Http\Requests\Hrm\EmployeeContactFormRequest;
use App\Services\Hrm\EmployeeService;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules;
use DataTables;

class EmployeeController extends Controller
{

    private EmployeeService $employeeService;
    public function __construct(
        EmployeeService $employeeService
    )
    {
        $this->employeeService = $employeeService;
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = HrmEmployee::latest();

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('name', function($row){
                    $name = $row->first_name . ' ' . $row->last_name;
                    return $name;
                })
                ->addColumn('businessUnit', function($row){
                    $name = $row->defaultBusinessUnit->name;
                    return $name;
                })
                ->addColumn('action', function($row){
                    $btn = ' <div class="flex gap-3">';
                    $btn .= '<a class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500" href="'.route('admin.hrm.employee.view', ['code' => encrypt($row->code)]) .'"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="eye" class="lucide lucide-eye inline-block size-3"><path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"></path><circle cx="12" cy="12" r="3"></circle></svg> </a>';
                    $btn .= '<a href="#!" data-modal-target="deleteModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 remove-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="trash-2" class="lucide lucide-trash-2 size-4"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path><line x1="10" x2="10" y1="11" y2="17"></line><line x1="14" x2="14" y1="11" y2="17"></line></svg></a>';
                    $btn .= '</div>';
                    return $btn;
                })
                ->rawColumns(['action', 'name','businessUnit'])
                ->make(true);
        }
        //return $dataTable->render('admin.sales.customer-list');
        return view('admin.hrm.employeeList');
    }

    public function store(NewEmployeeFormRequest $request)
    {
        $validated = $request->validated();
        $data = $request->only(['first_name', 'last_name', 'date_birth','phone','email', 'national_id', 'religious', 'religious', 'blood_group','gender']);
        $data['country_id'] = $request->input('country');
        $data['business_units_id'] = $request->input('business_unit');
        $data['full_name'] = $request->input('first_name').' '.$request->input('last_name');
        $result = $this->employeeService->store($data);

        if(empty($result)){
            return response()->json(['error' => false, 'message' => __('Something went wrong!')]);
        }else{
            return response()->json([
                'message' => __('Employee created successfully!'),
                'redirect' => route('admin.hrm.employee.view', ['code' => encrypt($result->code)])
            ], 201);
        }
    }

    // Show the form for editing the specified resource.
    public function view($code)
    {
        $id = decrypt($code);
        $employee = HrmEmployee::with('businessUnits', 'stores')->findOrFail($id);
        if(!empty($employee)){
            $menu = 'info';
            return view('admin.hrm.viewEmployee', compact('employee', 'menu'));
        }else{
            return response()->json(['success' => false, 'message' => __('Something went wrong!')]);
        }
    }

    public function empInventory($code)
    {
        $id = decrypt($code);
        $employee = HrmEmployee::with('businessUnits', 'stores')->findOrFail($id);
        if(!empty($employee)){
            $menu = 'store';
            return view('admin.hrm.store', compact('employee', 'menu'));
        }else{
            return response()->json(['success' => false, 'message' => __('Something went wrong!')]);
        }
    }
    public function updateEmployeeInfo(NewEmployeeFormRequest $request, $id)
    {
        $data = $request->only(['first_name', 'last_name', 'date_birth', 'national_id', 'religious', 'religious', 'blood_group', 'marital_status','gender','phone','email']);
        $data['country_id'] = $request->input('country');
        $data['business_units_id'] = $request->input('business_unit');

        if($request->hasFile('photo')){
            $name = $request->file('photo')->getClientOriginalName();
            $file_info = pathinfo($name);
            $filename = $file_info['filename'].'-'.time().'.'.$file_info['extension'];

            $file = $request->file('photo');
            $file->move('uploads/employee/',$filename );
            $data['photo']  = $filename;
        }

        $result = $this->employeeService->update($id, $data);

        if(empty($result)){
            return response()->json(['error' => false, 'message' => __('Something went wrong!')]);
        }else{
            return response()->json([
                'success' => true,
                'message' => __('Record Updated successfully!'),
                'data' => $result
            ]);


        }
    }

    public function storeEmployeeContact(EmployeeContactFormRequest $request, $id)
    {
        $data = $request->only(['employee_id','address_line_1','address_line_2','country_id','city','state','zip','home_phone','emp_phone','emp_email']);

        $result = $this->employeeService->contact($id, $data);

        if(empty($result)){
            return response()->json(['error' => false, 'message' => __('Something went wrong!')]);
        }else{
            return response()->json([
                'success' => true,
                'message' => __('Record Updated successfully!'),
                'data' => $result
            ]);

        }
    }

  /*
   * Employee Login Section
   * */
    public function login($code)
    {
        $id = decrypt($code);
        $employee = HrmEmployee::with('businessUnits', 'stores')->findOrFail($id);
        $employeeLogin = Admin::where('employee_id', $id)->first();
        if(!empty($employee)){
            $menu = 'login';
            return view('admin.hrm.login', compact('employee','employeeLogin', 'menu'));
        }else{
            return response()->json(['success' => false, 'message' => __('Something went wrong!')]);
        }
    }

    public function storeEmployeeLogin( Request $request, $id)
    {
        $employeeId = decrypt($id);
        $employee = HrmEmployee::find($employeeId);
        $employeeLogin = Admin::where('employee_id', $employeeId)->first();

        $request->validate([
            'username' => ['string', 'max:255', Rule::unique('admins')->ignore($employeeLogin?->id)],
            'password' => [ $employeeLogin ? 'nullable' : 'required', 'confirmed', Rules\Password::defaults()],
            'selectedRole' => ['required'],
        ]);


        $employeeLogin = Admin::updateOrCreate(
            ['id' => $employeeLogin?->id],  // Find user by email
            [
                'username'      => $request->username,
                'password'      => $request->password
                                ? Hash::make($request->password)  // Hash password if provided
                                : $employeeLogin->password,       // Keep old password
                'name'          => $employee->fullName,
                'employee_id'   => $employee->id,
                'user_type'     => AdminsEnum::EMPLOYEE,
            ]   // Update or insert these values
        );


        $employeeLogin->roles()->detach();
        if (!empty($request->selectedRole)) {
            $employeeLogin->assignRole($request->selectedRole);
        }


        if(empty($employeeLogin)){
            return response()->json(['error' => false, 'message' => __('Something went wrong!')]);
        }else{
            return response()->json([
                'success' => true,
                'message' => __('Record Updated successfully!')
            ]);

        }
    }

    public function destroy($id)
    {
        $result = $this->inventoryStoreService->delete($id);

        if(empty($result)){
            return response()->json(['error' => false, 'message' => __('Something went wrong!')]);
        }else{
            return response()->json(['success' => true, 'message' => __('Delete Record successfully!')]);
        }
    }

    public function findStoreByBUnit(Request $request,$employee_id)
    {
        $output = '';
        $employee_id = decrypt($employee_id);
        $stores = SetupInventoryStore::whereIn('business_units_id', $request->selected)->get();
        $groupedStores = $stores->groupBy('business_units_id');
        foreach ($groupedStores as $bUnit => $storeInUnit) {


            $output .= '<h6 class="mb-1 text-16">'. SetupBusinessUnit::getUnitInfo($bUnit)->name.'</h6>';
            $output .= '<hr class="mb-3"/>';

            $output .= '
                <div class="flex flex-wrap gap-2 mb-8">
            ';
            foreach ($storeInUnit as $store) {
                $hasStore = HrmEmployeeStore::employeeStore($employee_id,$store->id);
               $output .= '
                        <div class="flex items-center gap-2">
                            <input class="border-checkbox" type="checkbox" id="'.$store->id.'" value="'.$store->id.'" name="stores[]" '.$hasStore.'>
                            <label class="border-checkbox-label" for="'.$store->id.'"> '.$store->name.'</label>
                        </div>
               ';
            }
            $output .= '
                            </div>

            ';
        }

       echo $output;
    }

    public function storeEmployeeBusinessUnitStore(Request $request,$employee_id)
    {
        $request->validate([
            'business_units' => 'required|array',
            'stores' => 'required|array',
        ]);
        $employee_id = decrypt($employee_id);
        $employee = HrmEmployee::find($employee_id);
        $employee->businessUnits()->sync($request->business_units);
        $employee->stores()->sync($request->stores);

        return response()->json([
            'success' => true,
            'message' => __('Record Updated successfully!'),
            'data' => 1
        ]);
    }
}
