<?php

namespace App\Http\Controllers\Admin\Inventory\Setup;

use App\Enums\InventoryEnum;
use App\Http\Controllers\Controller;
use App\Models\Inventory\InventoryAttribute;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules;
use DataTables;
class AttributeController extends Controller
{

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = InventoryAttribute::latest('id');

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){

                        $btn = '<div class="flex gap-2">';
                    if(!$row->system) {
                        $btn .= '<button class="anchor-button" onclick="openModal(' . $row->id . ')" >
                                <i class="ri-edit-box-line"></i>
                                </button>';

                        $btn .= '<button class="anchor-button" onclick="deleteItem(' . $row->id . ', '.$row->code.' , \'' . addslashes($row->name) . '\')" >
                                <i class="ri-delete-bin-line text-red-500"></i>
                                </button>';
                    }
                        $btn .= '</div>';

                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        //return $dataTable->render('admin.sales.customer-list');
        return view('admin.inventory.setup.attribute-list');
    }

    public function storeOrUpdate(Request $request)
    {
        $validated = $request->validate([

            'name' => 'required|string|max:255|unique:inventory_item_attributes,name,' . ($request->id ?? 'NULL') . ',id',
        ]);

        $category = InventoryAttribute::updateOrCreate(
            ['id' => $request->id],
            [
                'name' => $request->name,
                'is_active' => $request->is_active,
            ]
        );

        return redirect()->back()->with('success', ($request->id ? __('Record Updated') : __('Record Created')) . __('successfully!'));
    }

    public function edit($id)
    {
        $group = InventoryAttribute::find($id);
        return response()->json($group);
    }

    public function delete(Request $request)
    {
        try {
            $inventory = InventoryAttribute::find($request->input('id'));
            $inventory = $inventory->delete();

            if(empty($inventory)){
                session()->flash('error', __('Something went wrong!'));
            }else{
                session()->flash('success', __('Record Deleted Successfully'));
            }

        } catch (QueryException $e) {
            session()->flash('error', $e->getMessage());
        }

        return response()->json(['success' => true, 'redirect' => route('admin.inventory.setup.attributeList')]);


    }

}
