<?php

namespace App\Http\Controllers\Admin\Inventory\Setup;

use App\Enums\InventoryEnum;
use App\Enums\GlobalEnum;
use App\Http\Controllers\Controller;
use App\Models\Inventory\InventoryAttribute;
use App\Models\Inventory\InventoryAttributeValue;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules;
use DataTables;
class AttributeValueController extends Controller
{

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = InventoryAttributeValue::with('attribute')->latest('id');

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('attribute', function($row){
                    return $row->attribute->name;
                })
                ->addColumn('action', function($row){

                    $btn = '<div class="flex gap-2">';
                    $btn .= '<button class="anchor-button" onclick="openModal(' . $row->id . ')" >
                                <i class="ri-edit-box-line"></i>
                                </button>';

                    $btn .= '<button class="anchor-button" onclick="deleteItem(' . $row->id . ', '.$row->code.' , \'' . addslashes($row->name) . '\')" >
                                <i class="ri-delete-bin-line text-red-500"></i>
                                </button>';
                    $btn .= '</div>';

                    return $btn;
                })
                ->filter(function ($query) use ($request) {
                    if ($request->has('search') && $search = $request->input('search.value')) {
                        $query->whereHas('attribute', function ($q) use ($search) {
                            $q->where('name', 'like', "%{$search}%");
                        });
                    }
                })
                ->rawColumns(['action','attribute'])
                ->make(true);
        }

        $attributes = InventoryAttribute::where('is_active', GlobalEnum::ACTIVE )->get();
        return view('admin.inventory.setup.attribute-value-list', compact('attributes'));
    }

    public function storeOrUpdate(Request $request)
    {
        $validated = $request->validate([

            'name' => 'required',
            'attribute' => 'required',
        ]);

        $result = InventoryAttributeValue::updateOrCreate(
            ['id' => $request->id],
            [
                'value' => $request->name,
                'inventory_item_attribute_id' => $request->attribute,
                'is_active' => $request->is_active,
                'category_level' => InventoryEnum::CATEGORY
            ]
        );

        return redirect()->back()->with('success', ($request->id ? __('Record Updated') : __('Record Created')) . __('successfully!'));
    }

    public function edit($id)
    {
        $data = InventoryAttributeValue::find($id);
        return response()->json($data);
    }
    public function delete(Request $request)
    {
        try {
            $inventory = InventoryAttributeValue::find($request->input('id'));
            $inventory = $inventory->delete();

            if(empty($inventory)){
                session()->flash('error', __('Something went wrong!'));
            }else{
                session()->flash('success', __('Record Deleted Successfully'));
            }

        } catch (QueryException $e) {
            session()->flash('error', $e->getMessage());
        }

        return response()->json(['success' => true, 'redirect' => route('admin.inventory.setup.attributeValueList')]);


    }

}
