<?php

namespace App\Http\Controllers\Admin\Inventory\Setup;

use App\Enums\InventoryEnum;
use App\Http\Controllers\Controller;
use App\Models\Inventory\InventoryCategory;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules;
use DataTables;
class ChartInventoryController extends Controller
{

    public function index(Request $request)
    {
        $inventories = InventoryCategory::where('category_level', '=', 'Head')->get();
        return view('admin.inventory.setup.chart_inventory', compact('inventories'));
    }

    public function inventoryStoreOrUpdate(Request $request)
    {
        $validated = $request->validate([
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('inventory_categories')
                    ->where(function ($query) use ($request) {
                        return $query->where('category_level', $request->inventory_level)
                                     ->where('parent_id', $request->parent_id);
                    })
                    ->ignore($request->id), // For update scenarios
            ],
        ]);

        if ($request->id) {
            // Only update 'name' if ID is provided
            $category = InventoryCategory::where('id', $request->id)
                ->update([
                    'name' => $request->name
                ]);
        } else {
            // Create new record with all fields
            $category = InventoryCategory::create([
                'name' => $request->name,
                'is_active' => $request->is_active,
                'category_level' => $request->inventory_level,
                'parent_id' => $request->parent_id
            ]);
        }

        return redirect()->back()->with('success', ($request->id ? __('Record Updated') : __('Record Created')) . __('successfully!'));
    }

    public function editGroup($id)
    {
        $group = InventoryCategory::find($id);
        return response()->json($group);
    }

    public function inventoryDelete(Request $request)
    {
        try {
            $inventory = InventoryCategory::find($request->input('id'));
            $inventory = $inventory->delete();

            if(empty($inventory)){
                session()->flash('error', __('Something went wrong!'));
            }else{
                session()->flash('success', __('Record Deleted Successfully'));
            }

        } catch (QueryException $e) {
            session()->flash('error', $e->getMessage());
        }

        return response()->json(['success' => true, 'redirect' => route('admin.inventory.setup.chart-of-inventory')]);


    }

}
