<?php

namespace App\Http\Controllers\Admin\Inventory\Setup;

use App\Enums\InventoryEnum;
use App\Http\Controllers\Controller;
use App\Models\Inventory\InventoryCategory;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules;
use DataTables;
class GroupController extends Controller
{

    public function index(Request $request)
    {
        if ($request->ajax()) {

            $data = InventoryCategory::where('category_level', InventoryEnum::GROUP)->latest('id');

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<div class="flex gap-2">';
                    $btn .= '<button class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500" onclick="openModal('.$row->id.')" ><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="eye" class="lucide lucide-eye inline-block size-3"><path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"></path><circle cx="12" cy="12" r="3"></circle></svg> </button>';

                    $btn .= '</div>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        //return $dataTable->render('admin.sales.customer-list');
        return view('admin.inventory.setup.groupList');
    }

    public function storeOrUpdate(Request $request)
    {
        $validated = $request->validate([

            'name' => 'required|string|max:255|unique:inventory_categories,name,' . ($request->id ?? 'NULL') . ',id',
        ]);

        $category = InventoryCategory::updateOrCreate(
            ['id' => $request->id],
            [
                'name' => $request->name,
                'is_active' => $request->is_active,
                'category_level' => InventoryEnum::GROUP
            ]
        );

        return redirect()->back()->with('success', ($request->id ? __('Record Updated') : __('Record Created')) . __('successfully!'));
    }

    public function editGroup($id)
    {
        $group = InventoryCategory::find($id);
        return response()->json($group);
    }

}
