<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use Illuminate\Http;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Validation;
use App\Models\User;
use session;

class RolesController extends Controller
{
    public $user;

    public function __construct()
    {

        $this->middleware(function($request, $next){
            $this->user = Auth::guard('admin')->user();
            return $next($request);
        });
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
//        if(is_null($this->user) || !$this->user->can('role.view')){
//            abort(403, 'Unauthorized Access');
//        }
        $roles = Role::all();
        //$permission_groups = Admin::getpermissionGroups();
        return view('admin.roles.index',compact('roles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
//        if(is_null($this->user) || !$this->user->can('role.create')){
//            abort(403, 'Unauthorized Access');
//        }

        $permissions = Permission::all();
        $permission_groups = Admin::getpermissionGroups();
        return view('admin.roles.create',compact('permissions','permission_groups'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
//        if(is_null($this->user) || !$this->user->can('role.create')){
//            abort(403, 'Unauthorized Access');
//        }
        //Validate Data
        $request->validate([
            'name'  =>  'required|max:100|unique:roles'
        ],[
            'name.required' =>  'Please give a role name'
        ]);

        //Process Data
        $role = Role::create(['name'    => $request->name, 'guard_name' => 'admin' ]);
        $permissions = $request->input('permissions');

        if(!empty($permissions)){
            $role->syncPermissions($permissions);
        }

        return back()->with('success', 'Role has been create!!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
//        if(is_null($this->user) || !$this->user->can('role.edit')){
//            abort(403, 'Unauthorized Access');
//        }

        $role = Role::findById($id,'admin');
        $all_permissions = Permission::all();
        $permission_groups = Admin::getpermissionGroups();
        return view('admin.roles.edit',compact('role','all_permissions','permission_groups'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
//        if(is_null($this->user) || !$this->user->can('role.edit')){
//            abort(403, 'Unauthorized Access');
//        }
//
//        if(is_null($this->user) || !$this->user->can('role.create')){
//            abort(403, 'Unauthorized Access');
//        }

        //Validate Data
        $request->validate([
            'name'  =>  'required|max:100|unique:roles,name,'.$id
        ],[
            'name.required' =>  'Please give a role name'
        ]);

        $role = Role::findById($id,'admin');

        //Process Data
        $permissions = $request->input('permissions');

        if(!empty($permissions)){
            $role->name = $request->name;
            $role->save();
            $role->syncPermissions($permissions);
        }
        //Session::flash('success', 'Role has been Updated!!');
        return back()->with('success', 'Role has been Updated!!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        if(is_null($this->user) || !$this->user->can('role.delete')){
//            abort(403, 'Unauthorized Access');
//        }

       $role = Role::findById($id, 'admin');
       if(!is_null($role)){
           $role->delete();
       }

        return back()->with('success', 'Role has been create!!');
    }
}
