<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Database\QueryException;
use PDOException;
use Symfony\Component\HttpFoundation\Response;

class HandleDatabaseErrors
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
            return $next($request);
        } catch (QueryException | PDOException $e) {
            Log::error('Database Error: ' . $e->getMessage());

            // For web routes (non-API), redirect back with a session flash
            if (!$request->expectsJson()) {
                Session::flash('error', 'A database error occurred: ' . $e->getMessage());
                return redirect()->back();
            }

            // For API requests
            return response()->json(['error' => 'A database error occurred.'], 500);
        }
    }
}
