<?php

namespace App\Http\Requests\Hrm;

use Illuminate\Foundation\Http\FormRequest;

class NewEmployeeFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'business_unit' => 'required',
            'date_birth' => 'required',
            'country' => 'required',
            'religious' => 'required',
            'marital_status' => 'required',
            'gender' => 'required',
            'phone' => 'required',
            'email' => 'email|nullable',
            'photo' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
        ];
    }
}
