<?php

namespace App\Http\Requests\Inventory;

use Illuminate\Foundation\Http\FormRequest;

class SalabelItemFormRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        return [
//            'id' => 'nullable|exists:inventory_items,id',
            'title' => 'required',
            'description' => 'required',
            'sales_price' => 'required|numeric',
            'taxes_id' => 'required',
            'brand_id' => 'required',
            'purchase_type' => 'required',
            'purchase_unit' => 'required',
            'unit_conversion' => 'required',
            'sales_unit' => 'required',
            'final_category_id' => 'required',
            'serial_no' => 'nullable',
            'lot_no' => 'nullable',
            'hscode' => 'nullable',
            'item_img' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048', // max 2MB

            //'item_img' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
        ];


    }

    public function messages()
    {
        return [
            'final_category_id.required' => 'The category field is required.',
        ];
    }
}
