<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SetupBusinessUnit extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'name',
        'short_name',
        'code_prefix',
        'email',
        'phone',
        'address',
        'city',
        'state',
        'zip',
        'country_id',
        'companies_id',
        'users_id',
        'logo',
        'is_active',
    ];

    public static function getUnitInfo($id)
    {
        return SetupBusinessUnit::find($id);
    }

    public function stores()
    {
        return $this->belongsTo(SetupInventoryStore::class, 'business_units_id');
    }

}
