<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SetupInventoryStore extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'name',
        'email',
        'phone',
        'address',
        'city',
        'state',
        'zip',
        'country_id',
        'business_units_id',
        'users_id',
        'logo',
        'is_active',
    ];

    public function businessUnit()
    {
        return $this->belongsTo(SetupBusinessUnit::class, 'business_units_id');
    }

}
