<?php

namespace App\Models\Hrm;

use App\Models\Business\SetupBusinessUnit;
use App\Models\Business\SetupInventoryStore;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrmEmployee extends Model
{
    use HasFactory;



    protected $fillable = [
        'code',
        'first_name',
        'last_name',
        'full_name',
        'date_birth',
        'joined_date',
        'probation_end_date',
        'date_of_permanent',
        'national_id',
        'photo',
        'phone',
        'email',
        'country_id',
        'departments_id',
        'designations_id',
        'business_units_id',
        'inventory_store_id',
        'religious',
        'religious',
        'blood_group',
        'gender',
        'marital_status',
        'is_active',
    ];

    public function defaultBusinessUnit()
    {
        return $this->belongsTo(SetupBusinessUnit::class, 'business_units_id', 'id');
    }

    public function businessUnits()
    {
        return $this->belongsToMany(SetupBusinessUnit::class, 'hrm_employee_business_units', 'employee_id', 'business_unit_id');
    }

    public function stores()
    {
        return $this->belongsToMany(SetupInventoryStore::class, 'hrm_employee_stores', 'employee_id', 'store_id');
    }

    public function getFullNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }
}
