<?php

namespace App\Models\Hrm;

use App\Models\Business\SetupBusinessUnit;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrmEmployeeContact extends Model
{
    use HasFactory;



    protected $fillable = [
        'employee_id',
        'address_line_1',
        'address_line_2',
        'city',
        'state',
        'zip',
        'country_id',
        'emp_phone',
        'emp_email',
        'home_phone',
    ];

    public function business_unit()
    {
        return $this->belongsTo(HrmEmployee::class, 'employee_id', 'id');
    }

}
