<?php

namespace App\Models\Inventory;

use App\Enums\InventoryEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class InventoryAttribute extends Model
{
    use HasFactory;
    protected $fillable = [
        'code',
        'name',
        'is_active',
        'serial',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($unit) {
            if (empty($unit->code)) {
                $maxGroup = InventoryAttribute::max('id');
                $nextNumber = $maxGroup ? intval($maxGroup) + 1 : 1;
                $unit->code = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
            }

        });
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', 'Active');
    }

    public function values()
    {
        return $this->hasMany(InventoryAttributeValue::class);
    }


    public function items()
    {
        return $this->belongsToMany(InventoryItem::class, 'inventory_item_attributes');
    }



}
