<?php

namespace App\Models\Inventory;

use App\Enums\InventoryEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class InventoryAttributeValue extends Model
{
    use HasFactory;
    protected $fillable = [
        'code',
        'inventory_item_attribute_id',
        'value',
        'is_active',
        'serial',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($unit) {
            if (empty($unit->code)) {
                $maxGroup = InventoryAttributeValue::max('id');
                $nextNumber = $maxGroup ? intval($maxGroup) + 1 : 1;
                $unit->code = str_pad($nextNumber, 5, '0', STR_PAD_LEFT);
            }

        });
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', 'Active');
    }

    public function attribute()
    {
        return $this->belongsTo(InventoryAttribute::class, 'inventory_item_attribute_id');
    }




}
