<?php

namespace App\Models\Inventory;

use App\Enums\GlobalEnum;
use App\Enums\InventoryEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use App\Services\Inventory\InventoryService;

class InventoryCategory extends Model
{
    use HasFactory;
    protected $fillable = [
        'code',
        'name',
        'parent_id',
        'category_level',
        'is_active',
        'serial',
    ];

    const CATEGORY_CODE_SEGMENT_WIDTH = 2;
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($category) {

            $category->code = InventoryService::generateCategoryCode($category->parent_id);

            // Generate URL from name if empty
            if (empty($category->url)) {
                $slug = Str::slug($category->name);
                $category->url = InventoryService::makeUniqueSlug($slug);
            }

        });
    }

    public function childInventories()
    {
        return $this->hasMany(InventoryCategory::class, 'parent_id', 'id');
    }

    public function parentInventories()
    {
        return $this->belongsTo(InventoryCategory::class);
    }
    public function parent()
    {
        return $this->belongsTo(InventoryCategory::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(InventoryCategory::class, 'parent_id');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', GlobalEnum::ACTIVE);
    }


}
