<?php

namespace App\Models\Inventory;

use App\Enums\InventoryEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class InventoryItemSku extends Model
{
    use HasFactory;
    protected $fillable = [
        'sku_code',
        'inventory_item_id',
        'is_variant',
        'attribute_value_map',
        'sku',
        'buying_price',
        'selling_price',
        'image',
        'is_active',
        'serial',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($item) {
            if (empty($item->sku)) {
                $timestamp = now()->timestamp; // Current Unix timestamp
                $random = rand(1000, 9999);    // 4-digit random number
                $item->sku = $timestamp . '-' . $random;
            }

        });
    }

    protected $casts = [
        'attribute_value_map' => 'array',
    ];

    public function item()
    {
        return $this->belongsTo(InventoryItem::class);
    }

    public function attributeValues()
    {
        return $this->belongsToMany(InventoryAttributeValue::class, 'inventory_item_sku_attribute_values')
            ->withPivot('inventory_attribute_id'); // optional, for clarity
    }



}
