<?php

namespace App\Models\Inventory;

use App\Enums\InventoryEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class InventoryUnit extends Model
{
    use HasFactory;
    protected $fillable = [
        'code',
        'name',
        'is_active',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($unit) {
            if (empty($unit->code)) {
                $maxGroup = InventoryUnit::max('id');
                $nextNumber = $maxGroup ? intval($maxGroup) + 1 : 1;
                $unit->code = str_pad($nextNumber, 2, '0', STR_PAD_LEFT);
            }

        });
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', 'Active');
    }

}
