<?php

namespace App\Services\Business;
use App\Models\Business\SetupBusinessUnit;
use Illuminate\Support\Facades\Auth;

class BusinessUnitService
{
    public function store(array $attributes){
        $maxId = (SetupBusinessUnit::max('id')) + 1;
        $attributes['code'] = str_pad($maxId, 4, '0', STR_PAD_LEFT);
        $attributes['users_id'] = Auth::guard('admin')->user()->id;
        $attributes['companies_id'] = 1;
        return SetupBusinessUnit::create($attributes);
    }

    public function update($id, array $attributes)
    {
        $id = decrypt($id);
        $record = SetupBusinessUnit::find($id);
        return $record->update($attributes);
    }

    public function delete($id)
    {
        $id = decrypt($id);
        $record = SetupBusinessUnit::findOrFail($id)->delete();
        return $record;
    }
}
