<?php

namespace App\Services\Business;
use App\Models\Business\SetupInventoryStore;
use Illuminate\Support\Facades\Auth;

class InventoryStoreService
{
    public function store(array $attributes){
        $maxId = (SetupInventoryStore::max('id')) + 1;
        $attributes['code'] = str_pad($maxId, 4, '0', STR_PAD_LEFT);
        $attributes['users_id'] = Auth::guard('admin')->user()->id;
        return SetupInventoryStore::create($attributes);
    }

    public function update($id, array $attributes)
    {
        $id = decrypt($id);
        $record = SetupInventoryStore::find($id);
        return $record->update($attributes);
    }

    public function delete($id)
    {
        $id = decrypt($id);
        $record = SetupInventoryStore::findOrFail($id)->delete();
        return $record;
    }
}
