<?php

namespace App\Services\Hrm;
use App\Models\Hrm\HrmEmployee;
use App\Models\Hrm\HrmEmployeeContact;
use Illuminate\Support\Facades\Auth;

class EmployeeService
{
    public function store(array $attributes){
        $maxId = (HrmEmployee::max('id')) + 1;
        $attributes['code'] = str_pad($maxId, 5, '0', STR_PAD_LEFT);
        return HrmEmployee::create($attributes);
    }

    public function update($id, array $attributes)
    {
        $id = decrypt($id);
        $record = HrmEmployee::find($id);
        $result =  $record->update($attributes);
        if($result){
            return HrmEmployee::find($id,["first_name","last_name","email","phone","photo"]);
        }else{
            return false;
        }
    }

    public function contact($id, array $attributes)
    {
        $id = decrypt($id);
        if($id){
            $record = HrmEmployeeContact::find($id);
            $result =  $record->update($attributes);
        }else{
            $result =  HrmEmployeeContact::create($attributes);
        }

        if($result){
            return true;
        }else{
            return false;
        }
    }

    public function delete($id)
    {
        $id = decrypt($id);
        $record = HrmEmployee::findOrFail($id)->delete();
        return $record;
    }
}
