<?php

namespace App\Services\Inventory;
use App\Models\Inventory\InventoryCategory;

class InventoryService
{
    public function generateAttributeCombinations($attributes)
    {
        $combinations = [[]];

        foreach ($attributes as $values) {
            $temp = [];

            foreach ($combinations as $combination) {
                foreach ($values as $value) {
                    $label = is_array($value) && isset($value['label']) ? $value['label'] : (string) $value;
                    $temp[] = array_merge($combination, [$label]);
                }
            }

            $combinations = $temp;
        }

        return array_map(fn($combo) => implode('-', $combo), $combinations);
    }

//    public function generateCombinationTable(array $combinations, array $existingSkus = []): string
//    {
//        $output = '';
//
//        foreach ($combinations as $combination) {
//            $safeValue = htmlspecialchars($combination);
//            $price = $existingSkus[$combination] ?? '';
//            $output .= <<<HTML
//<tr>
//    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">
//        <input type="text" class="form-control" value="{$safeValue}" name="variants[]" readonly>
//    </td>
//
//    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">
//        <input type="text" class="form-control" value="{$price}" name="prices[]" >
//    </td>
//</tr>
//HTML;
//        }
//
//        return $output;
//    }

    public function generateCombinationTable(array $combinations, array $existingSkus = []): string
    {
        $output = '';

        foreach ($combinations as $combination) {
            // Handle both array and string combinations
            $label = is_array($combination) ? implode('-', array_values($combination)) : $combination;

            $safeValue = htmlspecialchars($label);
            $price = $existingSkus[$label]['price'] ?? '';
            $skuId = $existingSkus[$label]['id'] ?? '';

            $output .= <<<HTML
<tr>
    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">
        <input type="text" class="form-control" value="{$safeValue}" name="variants[]" readonly>
        <input type="hidden" name="skuIds[]" value="{$skuId}">
    </td>

    <td class="px-3.5 py-2.5 border border-slate-200 dark:border-zink-500">
        <input type="text" class="form-control" value="{$price}" name="prices[]" >
    </td>
</tr>
HTML;
        }

        return $output;
    }


    const CATEGORY_CODE_SEGMENT_WIDTH = 2;
    public static function generateCategoryCode($parentId = null)
    {
        $segmentWidth = self::CATEGORY_CODE_SEGMENT_WIDTH;

        if (is_null($parentId)) {
            // Top-level category
            $maxCode = InventoryCategory::whereNull('parent_id')
                ->selectRaw("MAX(CAST(SUBSTRING(code, 1, {$segmentWidth}) AS UNSIGNED)) as max_code")
                ->value('max_code') ?? 0;

            $nextSegment = str_pad($maxCode + 1, $segmentWidth, '0', STR_PAD_LEFT);
            return $nextSegment;
        }

        // Get parent
        $parent = InventoryCategory::findOrFail($parentId);
        $prefix = $parent->code;

        // Determine next segment
        $children = InventoryCategory::where('parent_id', $parentId)->get();

        $maxSegment = $children->map(function ($c) use ($segmentWidth) {
            return (int)substr($c->code, -$segmentWidth);
        })->max() ?? 0;

        $nextSegment = str_pad($maxSegment + 1, $segmentWidth, '0', STR_PAD_LEFT);

        return $prefix . $nextSegment;
    }

    public static function makeUniqueSlug($slug, $excludeId = null)
    {
        $originalSlug = $slug;
        $counter = 1;

        while (self::slugExists($slug, $excludeId)) {
            $slug = "{$originalSlug}-{$counter}";
            $counter++;
        }

        return $slug;
    }

    private static function slugExists($slug, $excludeId = null)
    {
        $query = InventoryCategory::where('url', $slug);

        if ($excludeId) {
            $query->where('id', '!=', $excludeId);
        }

        return $query->exists();
    }




}
