<?php

namespace App\View\Components;

use App\Models\Inventory\InventoryCategory;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class SelectInventoryCategory extends Component
{
    public $categories;
    public function __construct()
    {
        $this->categories = InventoryCategory::active()->where('parent_id', 1)->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.select-inventory-category',[
            'categories' => $this->categories,
        ]);
    }
}
