<?php

use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('setup_companies', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->string('short_name')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->text('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->string('currency_symbol')->nullable();
            $table->unsignedBigInteger('country_id');
            $table->foreign('country_id')->references('id')->on('setup_countries');
            $table->string('logo')->nullable();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });

        Schema::create('setup_business_units', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->string('short_name')->nullable();
            $table->string('code_prefix')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->unsignedBigInteger('companies_id');
            $table->foreign('companies_id')->references('id')->on('setup_companies');
            $table->unsignedBigInteger('country_id');
            $table->foreign('country_id')->references('id')->on('setup_countries');
            $table->string('logo')->nullable();
            $table->unsignedBigInteger('users_id');
            $table->foreign('users_id')->references('id')->on('admins');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });

        Schema::create('setup_inventory_stores', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->unsignedBigInteger('country_id');
            $table->string('logo')->nullable();
            $table->foreign('country_id')->references('id')->on('setup_countries');
            $table->unsignedBigInteger('users_id');
            $table->foreign('users_id')->references('id')->on('admins');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });




    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
