<?php

use App\Enums\AccountsEnum;
use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('code', 8)->unique();
            $table->string('name')->index();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->foreign('parent_id')->references('id')->on('account_accounts');
            $table->enum('accounts_level', [AccountsEnum::ACCOUNT_TYPES, AccountsEnum::ACCOUNT_HEAD, AccountsEnum::ACCOUNT_GROUPS, AccountsEnum::ACCOUNT_LEDGERS])->default(AccountsEnum::ACCOUNT_LEDGERS)->index();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->unique(['name', 'accounts_level']);
            $table->timestamps();
        });

        Schema::create('account_sub_ledger', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->unsignedBigInteger('accounts_id');
            $table->foreign('accounts_id')->references('id')->on('account_accounts');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('account_periods', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->date('start_date')->index();
            $table->date('end_date')->index();
            $table->enum('open_status', [AccountsEnum::VOID, AccountsEnum::OPEN, AccountsEnum::CLOSE])->default(AccountsEnum::VOID)->index();
            $table->string('user_email');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
