<?php

use App\Enums\AccountsEnum;
use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('posting_date')->index();
            $table->unsignedBigInteger('account_period_id');
            $table->foreign('account_period_id')->references('id')->on('account_periods');
            $table->enum('voucher_type', [AccountsEnum::OPENING_BALANCE, AccountsEnum::CLOSING_BALANCE, AccountsEnum::JOURNAL_VOUCHER, AccountsEnum::SALES_VOUCHER, AccountsEnum::SALES_RETURN, AccountsEnum::PURCHASE_VOUCHER, AccountsEnum::PURCHASE_RETURN, AccountsEnum::PAYMENT_VOUCHER, AccountsEnum::RECEIVE_VOUCHER, AccountsEnum::EXPENSE_VOUCHER, AccountsEnum::CONTRA_VOUCHER])->default(AccountsEnum::JOURNAL_VOUCHER)->index();
            //    String reference_code TODO Change after create item transaction
            //    ItemTransaction item_transaction TODO Change after create item transaction
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->text('narration')->nullable();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('account_transactions_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('account_transactions_id');
            $table->foreign('account_transactions_id')->references('id')->on('account_transactions')->onDelete('cascade');
            $table->date('posting_date')->index();
            $table->unsignedBigInteger('account_period_id');
            $table->foreign('account_period_id')->references('id')->on('account_periods');
            $table->unsignedBigInteger('accounts_id');
            $table->foreign('accounts_id')->references('id')->on('account_accounts');
            $table->unsignedBigInteger('sub_ledger_id')->nullable();
            $table->foreign('sub_ledger_id')->references('id')->on('account_sub_ledger');
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->enum('voucher_type', [AccountsEnum::OPENING_BALANCE, AccountsEnum::CLOSING_BALANCE, AccountsEnum::JOURNAL_VOUCHER, AccountsEnum::SALES_VOUCHER, AccountsEnum::SALES_RETURN, AccountsEnum::PURCHASE_VOUCHER, AccountsEnum::PURCHASE_RETURN, AccountsEnum::PAYMENT_VOUCHER, AccountsEnum::RECEIVE_VOUCHER, AccountsEnum::EXPENSE_VOUCHER, AccountsEnum::CONTRA_VOUCHER])->default(AccountsEnum::JOURNAL_VOUCHER)->index();
            $table->enum('dr_cr_type', [AccountsEnum::DR, AccountsEnum::CR])->default(AccountsEnum::DR)->index();
            $table->decimal('dr_amount', 15, 4)->default(0);
            $table->decimal('cr_amount', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });
    }

    /**setup_business_units
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
