<?php

use App\Enums\AccountsEnum;
use App\Enums\GlobalEnum;
use App\Enums\InventoryEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_categories', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->foreign('parent_id')->references('id')->on('inventory_categories');
            $table->enum('category_level', [InventoryEnum::HEAD, InventoryEnum::GROUP, InventoryEnum::CATEGORY, InventoryEnum::SUB_CATEGORY])->default(InventoryEnum::SUB_CATEGORY)->index();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->unique(['name', 'category_level']);
            $table->timestamps();
        });

        Schema::create('inventory_item_brands', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->string('logo')->nullable();
            $table->string('slug')->nullable();
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('inventory_item_taxes', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->decimal('tax');
            $table->string('calculation');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('inventory_item_attributes', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('inventory_item_attribute_values', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->unsignedBigInteger('inventory_item_attribute_id');
            $table->foreign('inventory_item_attribute_id')->references('id')->on('inventory_item_attributes');
            $table->string('value');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('inventory_periods', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->date('start_date')->index();
            $table->date('end_date')->index();
            $table->enum('open_status', [AccountsEnum::VOID, AccountsEnum::OPEN, AccountsEnum::CLOSE])->default(AccountsEnum::VOID)->index();
            $table->string('user_email');
            $table->timestamps();
        });

        Schema::create('inventory_units', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
