<?php

use App\Enums\GlobalEnum;
use App\Enums\InventoryEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_items', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('slug');
            $table->unsignedBigInteger('category_id');
            $table->foreign('category_id')->references('id')->on('inventory_categories');
            $table->unsignedBigInteger('brand_id');
            $table->foreign('brand_id')->references('id')->on('inventory_item_brands');
            $table->boolean('is_variant')->default(false);
            $table->integer('purchase_unit'); // TODO
            $table->integer('sales_unit'); // TODO
            $table->decimal('unit_conversion');
            $table->string('salable_type');
            $table->string('purchase_type');
            $table->string('lot_no');
            $table->string('hscode');
            $table->integer('variant_product'); // TODO
            $table->text('chosen_attribute'); // TODO
            $table->mediumText('choice_options'); // TODO
            $table->mediumText('chosen_attribute_options'); // TODO
            $table->mediumText('chosen_attribute_option_values'); // TODO
            $table->mediumText('variations'); // TODO
            $table->text('description');
            $table->unsignedBigInteger('taxes_id');
            $table->foreign('taxes_id')->references('id')->on('inventory_item_taxes');
            $table->string('item_img');
            $table->enum('published', [InventoryEnum::PUBLISHED, InventoryEnum::UNPUBLISHED])->default(InventoryEnum::UNPUBLISHED)->index();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('inventory_item_variants', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->unsignedBigInteger('inventory_item_id');
            $table->foreign('inventory_item_id')->references('id')->on('inventory_items');
            $table->boolean('is_variant')->default(false);
            $table->string('variant')->nullable();
            $table->string('sku');
            $table->decimal('buying_price');
            $table->decimal('price');
            $table->decimal('qty');
            $table->string('image');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
