<?php

use App\Enums\EmployeeEnum;
use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new  class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hrm_departments', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->index();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('hrm_designations', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->index();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });

        Schema::create('hrm_employees', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('full_name')->index();
            $table->date('date_birth')->nullable();
            $table->date('joined_date')->nullable();
            $table->date('probation_end_date')->nullable();
            $table->date('date_of_permanent')->nullable();
            $table->string('national_id')->nullable();
            $table->string('phone',20)->nullable();
            $table->string('email',50)->nullable();
            $table->string('photo')->nullable();
            $table->unsignedBigInteger('country_id');
            $table->foreign('country_id')->references('id')->on('setup_countries');
            $table->unsignedBigInteger('departments_id')->nullable();
            $table->foreign('departments_id')->references('id')->on('hrm_departments');
            $table->unsignedBigInteger('designations_id')->nullable();
            $table->foreign('designations_id')->references('id')->on('hrm_designations');
            $table->unsignedBigInteger('business_units_id')->nullable();
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->unsignedBigInteger('inventory_store_id')->nullable();
            $table->foreign('inventory_store_id')->references('id')->on('setup_inventory_stores');
            $table->enum('religious', [EmployeeEnum::HINDUISM, EmployeeEnum::JUDAISM, EmployeeEnum::BUDDHISM, EmployeeEnum::CHRISTIANITY, EmployeeEnum::ISLAM, EmployeeEnum::FOLK_RELIGION, EmployeeEnum::OTHER])->nullable();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->enum('gender', [EmployeeEnum::MALE, EmployeeEnum::FEMALE, EmployeeEnum::THIRD_GENDER])->default(EmployeeEnum::MALE);
            $table->enum('marital_status', [EmployeeEnum::SINGLE, EmployeeEnum::MARRIED])->default(EmployeeEnum::SINGLE);
            $table->enum('blood_group', [EmployeeEnum::A_POSITIVE, EmployeeEnum::A_NEGATIVE, EmployeeEnum::B_POSITIVE, EmployeeEnum::B_NEGATIVE, EmployeeEnum::O_POSITIVE, EmployeeEnum::O_NEGATIVE, EmployeeEnum::AB_POSITIVE, EmployeeEnum::AB_NEGATIVE])->nullable();
            $table->integer('serial')->default(1);
            $table->timestamps();
        });




    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
