<?php

use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_customers', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name');
            $table->string('company')->nullable();
            $table->string('vat')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->text('website')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->foreignId('setup_country_id')->nullable()->index();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->foreignId('admin_id')->constrained();
            $table->timestamps();
        });

        Schema::create('sales_customer_billing_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_customer_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('setup_country')->constrained();
            $table->text('address');
            $table->text('city')->nullable();
            $table->text('state')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('zip')->nullable();
            $table->boolean('is_default')->default(false);
            $table->timestamps();
        });

        Schema::create('sales_customer_shipping_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_customer_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('setup_country')->constrained();
            $table->string('name');
            $table->text('address');
            $table->text('city')->nullable();
            $table->text('state')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('zip')->nullable();
            $table->boolean('is_default')->default(false);
            $table->timestamps();
        });



    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
