<?php

use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_quotations', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('transaction_date')->index();
            $table->date('lead_date')->nullable();
            $table->text('narration')->nullable();
            $table->unsignedBigInteger('customer_id');
            $table->foreign('customer_id')->references('id')->on('sales_customers');
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->enum('sales_status', [GlobalEnum::DRAFT, GlobalEnum::PENDING, GlobalEnum::PROCESS, GlobalEnum::APPROVED, GlobalEnum::COMPLETE])->default(GlobalEnum::DRAFT)->index();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('sales_quotation_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sales_quotation_id');
            $table->foreign('sales_quotation_id')->references('id')->on('sales_quotations')->onDelete('cascade');
            $table->date('transaction_date');
            $table->integer('lead_date')->nullable();;
            $table->unsignedBigInteger('item_id');
            $table->foreign('item_id')->references('id')->on('inventory_items');
            $table->unsignedBigInteger('unit_id');
            $table->foreign('unit_id')->references('id')->on('inventory_units');
            $table->string('unit_name');
            $table->decimal('transaction_quantity', 15, 4)->default(0);
            $table->decimal('unit_price', 15, 4)->default(0);
            $table->decimal('line_total', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });

        Schema::create('sales_orders', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('transaction_date')->index();
            $table->date('lead_date')->nullable();
            $table->text('narration')->nullable();
            $table->unsignedBigInteger('sales_quotation_id')->nullable();
            $table->foreign('sales_quotation_id')->references('id')->on('sales_quotations');
            $table->unsignedBigInteger('customer_id');
            $table->foreign('customer_id')->references('id')->on('sales_customers');
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->enum('sales_status', [GlobalEnum::DRAFT, GlobalEnum::PENDING, GlobalEnum::PROCESS, GlobalEnum::APPROVED, GlobalEnum::COMPLETE])->default(GlobalEnum::DRAFT)->index();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('sales_order_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sales_order_id');
            $table->foreign('sales_order_id')->references('id')->on('sales_orders')->onDelete('cascade');
            $table->unsignedBigInteger('sales_quotation_line_id')->nullable();
            $table->foreign('sales_quotation_line_id')->references('id')->on('sales_quotation_lines');
            $table->date('transaction_date');
            $table->integer('lead_date')->nullable();;
            $table->unsignedBigInteger('item_id');
            $table->foreign('item_id')->references('id')->on('inventory_items');
            $table->unsignedBigInteger('unit_id');
            $table->foreign('unit_id')->references('id')->on('inventory_units');
            $table->string('unit_name');
            $table->decimal('transaction_quantity', 15, 4)->default(0);
            $table->decimal('unit_price', 15, 4)->default(0);
            $table->decimal('line_total', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });

        Schema::create('sales_billing_addresses', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->foreignId('sales_order_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('setup_country')->constrained();
            $table->text('address');
            $table->text('city')->nullable();
            $table->text('state')->nullable();
            $table->text('zip')->nullable();
            $table->boolean('is_default')->default(false);
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });

        Schema::create('sales_shipping_addresses', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->foreignId('sales_order_id')->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->foreignId('setup_country')->constrained();
            $table->text('address');
            $table->text('city')->nullable();
            $table->text('state')->nullable();
            $table->text('zip')->nullable();
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
