<?php

use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_suppliers', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->string('name')->unique();
            $table->string('company')->nullable();
            $table->string('vat')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->text('website')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->foreign('country_id')->references('id')->on('setup_countries');
            $table->enum('is_active', [GlobalEnum::ACTIVE, GlobalEnum::IN_ACTIVE])->default(GlobalEnum::ACTIVE)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
