<?php

use App\Enums\GlobalEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_item_requisitions', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('transaction_date')->index();
            $table->date('lead_date')->nullable();
            $table->text('narration')->nullable();
            $table->unsignedBigInteger('departments_id')->nullable();
            $table->foreign('departments_id')->references('id')->on('hrm_departments');
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->enum('requisition_status', [GlobalEnum::DRAFT, GlobalEnum::PENDING, GlobalEnum::PROCESS, GlobalEnum::APPROVED, GlobalEnum::COMPLETE])->default(GlobalEnum::DRAFT)->index();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('inventory_item_requisition_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('item_requisition_id');
            $table->foreign('item_requisition_id')->references('id')->on('inventory_item_requisitions')->onDelete('cascade');
            $table->date('transaction_date');
            $table->integer('lead_date')->nullable();
            $table->unsignedBigInteger('item_id');
            $table->foreign('item_id')->references('id')->on('inventory_items');
            $table->unsignedBigInteger('unit_id');
            $table->foreign('unit_id')->references('id')->on('inventory_units');
            $table->string('unit_name');
            $table->decimal('transaction_quantity', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });

        Schema::create('purchase_item_requisitions', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('transaction_date')->index();
            $table->date('lead_date')->nullable();
            $table->text('narration')->nullable();
            $table->unsignedBigInteger('item_requisition_id')->nullable();
            $table->foreign('item_requisition_id')->references('id')->on('inventory_item_requisitions');
            $table->unsignedBigInteger('departments_id')->nullable();
            $table->foreign('departments_id')->references('id')->on('hrm_departments');
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->enum('requisition_status', [GlobalEnum::DRAFT, GlobalEnum::PENDING, GlobalEnum::PROCESS, GlobalEnum::APPROVED, GlobalEnum::COMPLETE])->default(GlobalEnum::DRAFT)->index();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('purchase_item_requisition_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('item_requisition_id');
            $table->foreign('item_requisition_id')->references('id')->on('purchase_item_requisitions')->onDelete('cascade');
            $table->unsignedBigInteger('item_requisition_line_id')->nullable();
            $table->foreign('item_requisition_line_id')->references('id')->on('inventory_item_requisition_lines');
            $table->date('transaction_date');
            $table->integer('lead_date')->nullable();
            $table->unsignedBigInteger('item_id');
            $table->foreign('item_id')->references('id')->on('inventory_items');
            $table->unsignedBigInteger('unit_id');
            $table->foreign('unit_id')->references('id')->on('inventory_units');
            $table->string('unit_name');
            $table->decimal('transaction_quantity', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });

        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('transaction_date')->index();
            $table->date('lead_date')->nullable();
            $table->text('narration')->nullable();
            $table->unsignedBigInteger('supplier_id');
            $table->foreign('supplier_id')->references('id')->on('purchase_suppliers');
            $table->unsignedBigInteger('item_requisition_id')->nullable();
            $table->foreign('item_requisition_id')->references('id')->on('purchase_item_requisitions');
            $table->unsignedBigInteger('business_units_id');
            $table->foreign('business_units_id')->references('id')->on('setup_business_units');
            $table->enum('purchase_status', [GlobalEnum::DRAFT, GlobalEnum::PENDING, GlobalEnum::PROCESS, GlobalEnum::APPROVED, GlobalEnum::COMPLETE])->default(GlobalEnum::DRAFT)->index();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('purchase_order_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('purchase_order_id');
            $table->foreign('purchase_order_id')->references('id')->on('purchase_orders')->onDelete('cascade');
            $table->unsignedBigInteger('item_requisition_line_id')->nullable();
            $table->foreign('item_requisition_line_id')->references('id')->on('purchase_item_requisition_lines');
            $table->date('transaction_date');
            $table->integer('lead_date')->nullable();
            $table->unsignedBigInteger('item_id');
            $table->foreign('item_id')->references('id')->on('inventory_items');
            $table->unsignedBigInteger('unit_id');
            $table->foreign('unit_id')->references('id')->on('inventory_units');
            $table->string('unit_name');
            $table->decimal('transaction_quantity', 15, 4)->default(0);
            $table->decimal('unit_price', 15, 4)->default(0);
            $table->decimal('line_total', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
