<?php

use App\Enums\AccountsEnum;
use App\Enums\GlobalEnum;
use App\Enums\InventoryEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::create('inventory_item_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('code', 12)->unique();
            $table->date('transaction_date')->index();
            $table->enum('transaction_type', [AccountsEnum::OPENING_BALANCE, AccountsEnum::CLOSING_BALANCE, InventoryEnum::GRN, InventoryEnum::GOODS_DELIVERY, InventoryEnum::DIRECT_ISSUE, InventoryEnum::DIRECT_RECEIVE])->index();
            $table->unsignedBigInteger('sales_order_id')->nullable();
            $table->foreign('sales_order_id')->references('id')->on('sales_orders');
            $table->unsignedBigInteger('purchase_order_id')->nullable();
            $table->foreign('purchase_order_id')->references('id')->on('purchase_orders');
            $table->unsignedBigInteger('item_requisition_id')->nullable();
            $table->foreign('item_requisition_id')->references('id')->on('inventory_item_requisitions');
            $table->unsignedBigInteger('inventory_periods_id')->nullable();
            $table->foreign('inventory_periods_id')->references('id')->on('inventory_periods');
            $table->unsignedBigInteger('inventory_store_id')->nullable();
            $table->foreign('inventory_store_id')->references('id')->on('setup_inventory_stores');
            $table->text('narration')->nullable();
            $table->enum('approve_status', [GlobalEnum::DRAFT, GlobalEnum::CONFIRM, GlobalEnum::APPROVE, GlobalEnum::REJECT])->default(GlobalEnum::DRAFT)->index();
            $table->string('user_email')->nullable();
            $table->string('approved_by_user_email')->nullable();
            $table->timestamp('approved_by_time')->nullable();
            $table->timestamps();
        });

        Schema::create('inventory_item_transaction_lines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('transaction_id');
            $table->foreign('transaction_id')->references('id')->on('inventory_item_transactions')->onDelete('cascade');
            $table->unsignedBigInteger('sales_line_id')->nullable();
            $table->foreign('sales_line_id')->references('id')->on('sales_order_lines');
            $table->unsignedBigInteger('purchase_line_id')->nullable();
            $table->foreign('purchase_line_id')->references('id')->on('purchase_order_lines');
            $table->unsignedBigInteger('requisition_line_id')->nullable();
            $table->foreign('requisition_line_id')->references('id')->on('inventory_item_requisition_lines');
            $table->date('transaction_date')->index();
            $table->unsignedBigInteger('period_id');
            $table->foreign('period_id')->references('id')->on('inventory_periods');
            $table->unsignedBigInteger('item_id');
            $table->foreign('item_id')->references('id')->on('inventory_items');
            $table->unsignedBigInteger('unit_id');
            $table->foreign('unit_id')->references('id')->on('inventory_units');
            $table->string('unit_name');
            $table->enum('transaction_type', [AccountsEnum::OPENING_BALANCE, AccountsEnum::CLOSING_BALANCE, InventoryEnum::GRN, InventoryEnum::GOODS_DELIVERY, InventoryEnum::DIRECT_ISSUE, InventoryEnum::DIRECT_RECEIVE])->index();
            $table->enum('transaction_mode', [InventoryEnum::ISSUE, InventoryEnum::RECEIVE])->index();
            $table->decimal('issue_quantity', 15, 4)->default(0);
            $table->decimal('receive_quantity', 15, 4)->default(0);
            $table->decimal('unit_price', 15, 4)->default(0);
            $table->decimal('line_total', 15, 4)->default(0);
            $table->text('narration')->nullable();
            $table->timestamps();
        });


    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
