<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hrm_employee_business_units', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id');
            $table->foreign('employee_id')->references('id')->on('hrm_employees');
            $table->unsignedBigInteger('business_unit_id');
            $table->foreign('business_unit_id')->references('id')->on('setup_business_units');
            $table->timestamps();
        });

        Schema::create('hrm_employee_stores', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id');
            $table->foreign('employee_id')->references('id')->on('hrm_employees');
            $table->unsignedBigInteger('store_id');
            $table->foreign('store_id')->references('id')->on('setup_inventory_stores');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
