<x-admin-layout>
    @section('title', 'Employee List')
    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('HR')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Employee List')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('Employee List')}}</h6>
                <div class="grid grid-cols-1 gap-5 mb-5 xl:grid-cols-2">
                    <div>
                        <div class="relative xl:w-3/6">

                        </div>
                    </div>
                    <div class="ltr:md:text-end rtl:md:text-start">
                        <button type="button" data-modal-target="showModal" class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" data-bs-target="#showModal"><i class="align-bottom ri-add-line me-1"></i> {{__('Add Employee')}}</button>

                    </div>
                </div>
                <table id="dt-table" class="hover group" style="width:100%">
                    <thead>
                        <tr>
                            <th>{{ __('Code') }}</th>
                            <th>{{__('Name')}}</th>
                            <th>{{__('Business Unit')}}</th>
                            <th>{{__('Department')}}</th>
                            <th>{{__('Designation')}}</th>
                            <th>{{__('Phone')}}</th>
                            <th>{{__('Status')}}</th>
                            <th>{{__('Action')}}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200 dark:divide-zink-500">

                    </tbody>

                </table>
            </div>
        </div><!--end card-->

    </div>

    <div id="showModal" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show">
        <div class="w-screen lg:w-[55rem] bg-white shadow rounded-md dark:bg-zink-600">
            <div class="flex items-center justify-between p-4 border-b border-slate-200 dark:border-zink-500">
                <h5 class="text-16" id="exampleModalLabel">{{__('Add Employee')}}</h5>
                <button data-modal-close="showModal" class="transition-all duration-200 ease-linear text-slate-400 hover:text-slate-500"><i data-lucide="x" class="size-5"></i></button>
            </div>
            <div class="max-h-[calc(theme('height.screen')_-_180px)] overflow-y-auto p-4">
                <form class="tablelist-form" id="postForm">
                    @csrf
                    <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12">

                        <div class="xl:col-span-6">
                            <x-input-field :value="old('first_name')"  :name="'first_name'" :label="__('First Name')" :mandatory="true" :disabled="false" />
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <x-input-field :value="old('last_name')"  :name="'last_name'" :label="__('Last Name')" :mandatory="true" :disabled="false" />
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <x-input-select :options="App\Models\Business\SetupBusinessUnit::where('is_active', 'Active')->get()" :value="old('business_unit' )" :name="'business_unit'" :label="__('Business Unit')" :mandatory="true" :disabled="false" />
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">Date of Birth</label>
                            <span class="text-red-500">*</span>
                            <input type="date" id="dateOdBirth" name="date_birth" class="form-control" value="">
                            <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <x-input-field :value="old('email')"  :name="'email'" :label="__('Email')" :mandatory="false" :disabled="false" />
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <x-input-field :value="old('phone')"  :name="'phone'" :label="__('Phone')" :mandatory="true" :disabled="false" />
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <x-input-select :options="App\Models\SetupCountry::all()" :value="old('country')" :name="'country'" :label="__('Country')" :mandatory="true" :disabled="false" />
                        </div><!--end col-->
                        <div class="xl:col-span-6">
                            <x-input-field :value="old('national_id')"  :name="'national_id'" :label="__('National Id')" :mandatory="false" :disabled="false" />
                        </div><!--end col-->
                        <div class="xl:col-span-6">
                            <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Religious')}}</label>
                            <span class="text-red-500">*</span>
                            <select id="religious" name="religious" data-choices="" class="form-control">
                                <option value="" >--{{__('Select')}}--</option>
                                @foreach (config('options.religious') as $key => $value)
                                    <option value="{{$key}}" >{{$value}}</option>
                                @endforeach
                            </select>
                            <p id="religiousError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->
                        <div class="xl:col-span-6">
                            <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Marital Status')}}</label>
                            <span class="text-red-500">*</span>
                            <select id="marital_status" name="marital_status" data-choices="" class="form-control">
                                <option value="" >--{{__('Select')}}--</option>
                                @foreach (config('options.marital_status') as $key => $value)
                                    <option value="{{$key}}" >{{$value}}</option>
                                @endforeach
                            </select>
                            <p id="marital_statusError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->
                        <div class="xl:col-span-6">
                            <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Gender')}}</label>
                            <span class="text-red-500">*</span>
                            <select id="gender" name="gender" data-choices="" class="form-control">
                                <option value="" >--{{__('Select')}}--</option>
                                @foreach (config('options.gender') as $key => $value)
                                    <option value="{{$key}}" >{{$value}}</option>
                                @endforeach
                            </select>
                            <p id="genderError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->
                        <div class="xl:col-span-6">
                            <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Blood Group')}}</label>
                            <span class="text-red-500">*</span>
                            <select id="blood_group" name="blood_group" data-choices="" class="form-control">
                                <option value="" >--{{__('Select')}}--</option>
                                @foreach (config('options.blood_group') as $key => $value)
                                    <option value="{{$key}}" >{{$value}}</option>
                                @endforeach
                            </select>
                            <p id="blood_groupError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->
                        <div class="xl:col-span-6">
                            <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Employee Photo')}}</label>
                            <input type="file" class="form-control" name="photo" >
                            <p id="photoError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->

                    </div>

                    <div class="flex justify-end gap-2">
                        <button type="button" data-modal-close="showModal" class="text-white btn bg-slate-500 border-slate-500 hover:text-white hover:bg-slate-600 hover:border-slate-600 focus:text-white focus:bg-slate-600 focus:border-slate-600 focus:ring focus:ring-slate-100 active:text-white active:bg-slate-600 active:border-slate-600 active:ring active:ring-slate-100 dark:ring-slate-400/10" data-modal-close="showModal">Close</button>

                        <button type="submit" class="btn-olive bg-green-500" >Add Employee</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">


        $(window).on("load", function() {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // new DataTable('#rowBorder1');

            var table = $('#dt-table').DataTable({
                processing: true,
                serverSide: true,
                searching: true,
                ajax: "{{ route('admin.hrm.employee.list') }}",
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'name', name: 'name'},
                    {data: 'businessUnit', name: 'businessUnit'},
                    {data: 'departments_id', name: 'departments_id'},
                    {data: 'designations_id', name: 'designations_id'},
                    {data: 'phone', name: 'phone'},
                    {data: 'is_active', name: 'is_active'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],

            });



            $('#postForm').on('submit', function (e) {
                e.preventDefault();

                $.ajax({
                    url: "{{ route('admin.hrm.employee.saveEmployee') }}",
                    type: 'POST',
                    data: $(this).serialize(),
                    success: function (response) {
                        window.location.href = response.redirect;
                    },
                    error: function (response) {
                        // Handle validation errors
                        if(response.status === 422) {
                            var errors = response.responseJSON.errors;
                            $('.error').text(''); // Clear previous errors
                            $.each(errors, function(key, value) {
                                $('#' + key + 'Error').text(value[0]);
                            });
                        }
                    }
                });
            });

        });


    </script>
</x-admin-layout>
