<div class="xl:col-span-3">
    <div class="card">
        <div class="card-body">
            <div class="flex items-center gap-3 mb-5">
                <div class="rounded-full bg-slate-100 shrink-0 dark:bg-zink-600">
                    @if(empty($employee->photo))
                        <img src="{{ asset('images/blank-profile.png') }}" alt="" class="rounded-full h-14">
                    @else
                        <img src="{{ asset('uploads/employee/'.$employee->photo) }}" alt="" class="rounded-full h-14">
                    @endif
                </div>
                <div class="grow">
                    <h6 class="mb-1 text-15">{{$employee->full_name}} <i data-lucide="badge-check" class="inline-block size-4 text-sky-500 fill-sky-100 dark:fill-sky-500/20"></i></h6>
                    <p class="text-slate-500 dark:text-zink-200">Software Developer</p>
                </div>
            </div>
            <div class="flex gap-1 mb-4">
                <p class="text-slate-500 dark:text-zink-200"><i data-lucide="user-circle" class="inline-block size-4 ltr:mr-1 rtl:ml-1 text-slate-500 dark:text-zink-200 fill-slate-100 dark:fill-zink-500"></i> {{$employee->email}}</p>
            </div>
            <div class="flex gap-1 mb-4">
                <p class="text-slate-500 dark:text-zink-200"><i data-lucide="map-pin" class="inline-block size-4 ltr:mr-1 rtl:ml-1 text-slate-500 dark:text-zink-200 fill-slate-100 dark:fill-zink-500"></i> {{$employee->phone}}</p>
            </div>

            <hr/>
            <ul class="flex flex-col w-full gap-2 mb-4 text-sm font-medium shrink-0 nav-tabs">
                <li class="group grow {{$menu == 'info' ? 'active':''}}">
                    <a href="{{route('admin.hrm.employee.view', ['code' => encrypt($employee->id)])}}" class="link-button"><i data-lucide="square-user-round" class="inline-block align-middle size-4 ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">{{__('Personal Info')}}</span></a>
                </li>
                <li class="group grow {{$menu == 'contact' ? 'active':''}}">
                    <a href="apps-social-friends.html" class="link-button"><i data-lucide="user" class="inline-block align-middle size-4 ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">{{__('Contact Details')}}</span></a>
                </li>
                <li class="group grow">
                    <a href="apps-social-event.html" class="link-button"><i data-lucide="calendar-days" class="inline-block align-middle size-4 ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">{{__('Job')}}</span></a>
                </li>
                <li class="group grow {{$menu == 'store' ? 'active':''}}">
                    <a href="{{route('admin.hrm.employee.store', ['code' => encrypt($employee->id)])}}" class="link-button"><i data-lucide="package-open" class="inline-block align-middle size-4 ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">{{__('Store')}}</span></a>
                </li>
                <li class="group grow">
                    <a href="apps-social-marketplace.html" class="link-button"><i data-lucide="dollar-sign" class="inline-block align-middle size-4 ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">{{__('Salary')}}</span></a>
                </li>
                <li class="group grow {{$menu == 'login' ? 'active':''}}">
                    <a href="{{route('admin.hrm.employee.login', ['code' => encrypt($employee->id)])}}" class="link-button"><i data-lucide="key-round" class="inline-block align-middle size-4 ltr:mr-1 rtl:ml-1"></i> <span class="align-middle">{{__('Login')}}</span></a>
                </li>
            </ul>

        </div>
    </div><!--end card-->


</div><!--end-->
