<x-admin-layout>
    @section('title', 'Edit Employee')

    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16">Employee Details</h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('HR')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Employee List')}} </li>
            </ul>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">
            {{--Profile & Navigation--}}
            @include('admin.hrm.employeeNavigation')


            <div class="col-span-12 lg:col-span-9 xl:col-span-9 2xl:col-span-9">
                <div class="card">
                    <div class="card-body">
                        <h5 class="text-16 pb-5">{{__('Employee Allocate Store')}}</h5>

                        <div id="message"></div>
                        <form id="postFormStore" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12">

                                <div class="xl:col-span-12">
                                    <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">{{__('Business Unit')}}</label>
                                    <span class="text-red-500">*</span>
                                    <select class="form-control" id="business_units" data-choices="" data-choices-removeitem="" name="business_units[]" multiple="">
                                        @foreach(\App\Models\Business\SetupBusinessUnit::all() as $item)
                                            <option value="{{$item->id}}"
                                                {{ isset($employee) && $employee->businessUnits->contains($item->id) ? 'selected' : '' }} >
                                                {{$item->name}}
                                            </option>
                                        @endforeach
                                    </select>
                                    <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->

                                <div class="xl:col-span-12">
                                    <div id="stores-section" >

                                    </div>
                                </div><!--end col-->





                            </div><!--end grid-->

                            <div class="mt-4 text-right">
                                <button type="submit" class="text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">Share Post</button>
                            </div>
                        </form>
                    </div>
                </div><!--end card-->
            </div>
        </div><!--end-->
    </div>

    <script type="text/javascript">

        $(window).on("load", function() {

            let selectedValues = $('#business_units').val(); // Get selected values
            sendSelectedValues(selectedValues);

            $('#business_units').on('change', function () {
                let selectedValues = $(this).val(); // Get selected values
                sendSelectedValues(selectedValues);
            });

            function sendSelectedValues(selectedValues) {
                $.ajax({
                    url: "{{ route('admin.hrm.employee.findStoreByBUnit',['id' => encrypt($employee->id)]) }}",
                    type: 'POST',
                    data: {
                        selected: selectedValues,
                        _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                    },
                    success: function (response) {
                        var itemsTable = $('#stores-section');
                        itemsTable.empty();
                        itemsTable.html(response);
                    },
                    error: function (xhr) {
                        console.error('Error:', xhr.responseText);
                    },
                });
            }


            $('#postFormStore').on('submit', function (e) {
                e.preventDefault();
                var formData = new FormData(this);
                $.ajax({
                    url: "{{ route('admin.hrm.employee.storeEmployeeBusinessUnitStore',['id' => encrypt($employee?->id)]) }}",
                    type: 'POST',
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        console.log(response.message)
                        if(response.success){
                            toastr.success(response.message);
                            console.log(response.data);
                        }else{
                            toastr.error(response.message);
                        }
                    },
                    error: function (response) {
                        // Handle validation errors
                        if(response.status === 422) {
                            var errors = response.responseJSON.errors;
                            $('.error').text(''); // Clear previous errors
                            $.each(errors, function(key, value) {
                                $('#' + key + 'Error').text(value[0]);
                            });
                        }
                    }
                });
            });

        });

    </script>

 </x-admin-layout>
