<x-admin-layout>
    @section('title', 'Employee Task List')
    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('Employee')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Task List')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('Employee Task List')}}</h6>

                <div class="card">
                    <div class="card-body">
                        <div class="grid grid-cols-1 gap-5 2xl:grid-cols-12">
                            <div class="2xl:col-span-5">
                                <h5 class="mb-1">Task Progress Bar</h5>
{{--                                <p class="text-slate-500 dark:text-zink-200">Average Base Salary (USD)</p>--}}
                                <div class="mt-6 mb-4">
                                    <div class="flex w-full h-10 rounded-md bg-slate-200 dark:bg-zink-600">
                                        <div class="flex items-center justify-center h-10 text-white bg-purple-500 ltr:last:rounded-r-md rtl:last:rounded-l-md ltr:first:rounded-l-md rtl:first:rounded-r-md" style="width: 50%">130 Min</div>
                                        <div class="flex items-center justify-center h-10 text-white bg-orange-500 ltr:last:rounded-r-md rtl:last:rounded-l-md ltr:first:rounded-l-md rtl:first:rounded-r-md" style="width: 50%">40%</div>
                                    </div>
                                </div>
                                <p>Rashed Zaman Task Progress report date of 26 June 2025</p>
                            </div><!--end col-->
                            <div class="2xl:col-span-5 2xl:col-start-8">
                                <div class="overflow-x-auto">
                                    <table class="w-full">
                                        <tbody>
                                        <tr>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent">Business Unit</td>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent font-semibold">Amanat Shah Spinning Mils Ltd</td>
                                        </tr>
                                        <tr>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent">Employee</td>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent font-semibold">Rashed Zaman</td>
                                        </tr>
                                        <tr>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent">Department</td>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent font-semibold">IT</td>
                                        </tr>
                                        <tr>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent">Designations</td>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent font-semibold">Software Developer</td>
                                        </tr>
                                        <tr>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent">Reporting Boss</td>
                                            <td class="px-3.5 first:pl-0 last:pr-0 py-2 border-y border-transparent font-semibold">Sadek Ahmed</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div><!--end col-->
                        </div><!--end grid-->
                    </div>
                </div>

                <div class="grid grid-cols-1 gap-4 mb-5 lg:grid-cols-12 xl:grid-cols-12">
                    <div class="lg:col-span-3 xl:col-span-2">
                        <input type="date" id="dateRangeFilterInput" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500  disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 flatpickr-input" placeholder="Select date" data-provider="flatpickr" data-date-format="d M, Y" data-range-date="true">
                    </div><!--end col-->
                    <div class="lg:col-span-3 xl:col-span-2">
                        <input type="date" id="dateRangeFilterInput" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500  disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 flatpickr-input" placeholder="Select date" data-provider="flatpickr" data-date-format="d M, Y" data-range-date="true">
                    </div><!--end col-->
                    <div class="lg:col-span-3 xl:col-span-2">
                        <button type="button" class="text-slate-500 btn bg-slate-200 border-slate-200 hover:text-slate-600 hover:bg-slate-300 hover:border-slate-300 focus:text-slate-600 focus:bg-slate-300 focus:border-slate-300 focus:ring focus:ring-slate-100 active:text-slate-600 active:bg-slate-300 active:border-slate-300 active:ring active:ring-slate-100 dark:bg-zink-600 dark:hover:bg-zink-500 dark:border-zink-600 dark:hover:border-zink-500 dark:text-zink-200 dark:ring-zink-400/50">Filter</button>
                    </div><!--end col-->
                    <div class="lg:col-start-10 lg:col-span-3 xl:col-span-2 xl:col-start-11">
                        <div class="lg:ltr:text-right lg:rtl:text-left">
                            <button type="button" data-modal-target="showModal" class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" data-bs-target="#showModal"><i class="align-bottom ri-add-line me-1"></i> {{__('Add Task')}}</button>
                        </div>
                    </div>
                </div>


                <table class="w-full whitespace-nowrap">
                    <thead class="ltr:text-left rtl:text-right">
                    <tr class="bg-slate-100 dark:bg-zink-600">
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 ID">Sl</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Name">Task</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Name">Assigned By</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Role">Frequency</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Email">Date</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Email">Form-To</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Phone">Duration</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Country">Process</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Country">Status</th>
                        <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 Action">Action</th>
                    </tr>
                    </thead>
                    <tbody class="list" id="employeeList">

                    <tr>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 ID">
                            01
                        </td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Role">Layout Design</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Email">Self</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Email">Daily</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Phone">26 June 2025</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Phone">9:54 AM - 11:41 PM</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Country">40 min</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Experience">30%</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 JoinDate">In Progress</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Action">
                            <div class="flex gap-3">
                                <a class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"
                                   data-modal-target="showModal" class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" data-bs-target="#showModal" href="#">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="eye" class="lucide lucide-eye inline-block size-3"><path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"></path><circle cx="12" cy="12" r="3"></circle></svg> </a>
                                <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="pencil" class="lucide lucide-pencil size-4"><path d="M17 3a2.85 2.83 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5Z"></path><path d="m15 5 4 4"></path></svg></a>
                                <a href="#!" data-modal-target="deleteModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 remove-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="trash-2" class="lucide lucide-trash-2 size-4"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path><line x1="10" x2="10" y1="11" y2="17"></line><line x1="14" x2="14" y1="11" y2="17"></line></svg></a>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 ID">02</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Role">DB Design</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Email">Self</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Email">Daily</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Phone">26 June 2025</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Phone">9:54 AM - 11:41 PM</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Country">40 min</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Experience">40%</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 JoinDate">In Progress</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Action">
                            <div class="flex gap-3">
                                <a class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"
                                   data-modal-target="showModal" class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" data-bs-target="#showModal" href="#">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="eye" class="lucide lucide-eye inline-block size-3"><path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"></path><circle cx="12" cy="12" r="3"></circle></svg> </a>
                                <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="pencil" class="lucide lucide-pencil size-4"><path d="M17 3a2.85 2.83 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5Z"></path><path d="m15 5 4 4"></path></svg></a>
                                <a href="#!" data-modal-target="deleteModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 remove-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="trash-2" class="lucide lucide-trash-2 size-4"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path><line x1="10" x2="10" y1="11" y2="17"></line><line x1="14" x2="14" y1="11" y2="17"></line></svg></a>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 ID">03 </td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Role">Algorithm</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Email">Self</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Email">Daily</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Phone">26 June 2025</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Phone">9:54 AM - 11:41 PM</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Country">40 min</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Experience">40%</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 JoinDate">In Progress</td>
                        <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 Action">
                            <div class="flex gap-3">
                                <a class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"
                                   data-modal-target="showModal" class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" data-bs-target="#showModal" href="#">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="eye" class="lucide lucide-eye inline-block size-3"><path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"></path><circle cx="12" cy="12" r="3"></circle></svg> </a>
                                <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="pencil" class="lucide lucide-pencil size-4"><path d="M17 3a2.85 2.83 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5Z"></path><path d="m15 5 4 4"></path></svg></a>
                                <a href="#!" data-modal-target="deleteModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-8 remove-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="trash-2" class="lucide lucide-trash-2 size-4"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path><line x1="10" x2="10" y1="11" y2="17"></line><line x1="14" x2="14" y1="11" y2="17"></line></svg></a>
                            </div>
                        </td>
                    </tr>
                  </tbody>
                </table>
            </div>
        </div><!--end card-->

    </div>

{{--    view Task Modal--}}
    <div id="showModal" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show">
        <div class="w-screen lg:w-[55rem] bg-white shadow rounded-md dark:bg-zink-600">
            <div class="flex items-center justify-between p-4 border-b border-slate-200 dark:border-zink-500">
                <h5 class="text-16" id="exampleModalLabel">View Task Details</h5>
                <button data-modal-close="showModal" class="transition-all duration-200 ease-linear text-slate-400 hover:text-slate-500"><i data-lucide="x" class="size-5"></i></button>
            </div>
            <div class="max-h-[calc(theme('height.screen')_-_180px)] overflow-y-auto p-4">
                <form class="tablelist-form" id="postForm">

                    @csrf
                    <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12">

                        <div class="xl:col-span-12">
                            <x-input-field :value="old('task_title')"  :name="'task_title'" :label="__('Task Title')" :mandatory="true" :disabled="false" />
                        </div><!--end col-->

                        <div class="xl:col-span-6">
                            <div class="xl:col-span-6">
                                @php
                                    $purchaseTypes = collect([
                                        (object)['id' => 'Daily Task', 'name' => __('Daily Task')],
                                        (object)['id' => 'Assigned Task', 'name' => __('Assigned Task')],
                                    ]);
                                @endphp
                                <x-input-select :options="$purchaseTypes" value="{{old('purchase_type', $product->purchase_type ?? '')}}" :name="'purchase_type'" :label="__('Task Type ?')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->
                        </div><!--end col-->


                        <div class="xl:col-span-6">
                            <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">Date</label>
                            <span class="text-red-500">*</span>
                            <input type="date" id="dateOdBirth" name="date" class="form-control" value="">
                            <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->

                        <div class="xl:col-span-4">
                            <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">Time From</label>
                            <span class="text-red-500">*</span>
                            <input type="time" id="dateOdBirth" name="time" class="form-control" value="">
                            <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->

                        <div class="xl:col-span-4">
                            <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">Time To</label>
                            <span class="text-red-500">*</span>
                            <input type="time" id="dateOdBirth" name="time" class="form-control" value="">
                            <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->

                        <div class="xl:col-span-4">
                            <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">Duration</label>
                            <input type="text" id="dateOdBirth" name="time" class="form-control" value="" readonly>
                            <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->

                        <div class="lg:col-span-2 xl:col-span-12">
                            <x-texteria-input value="{{ old('description', $product->description ?? '') }}"  :name="'description'" :label="__('Description')" :rows="5" :mandatory="false" :disabled="false" />
                        </div>

                        <div class="xl:col-span-6">
                            <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Attachemnt')}}</label>
                            <input type="file" class="form-control" name="photo" >
                            <p id="photoError" class="mt-1 text-sm text-red-500"></p>
                        </div><!--end col-->


                    </div>

                    <div class="flex justify-end gap-2">
                        <button type="button" data-modal-close="showModal" class="text-white btn bg-slate-500 border-slate-500 hover:text-white hover:bg-slate-600 hover:border-slate-600 focus:text-white focus:bg-slate-600 focus:border-slate-600 focus:ring focus:ring-slate-100 active:text-white active:bg-slate-600 active:border-slate-600 active:ring active:ring-slate-100 dark:ring-slate-400/10" data-modal-close="showModal">Close</button>

                        <button type="submit" class="btn-olive bg-green-500" >Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script type="text/javascript">

        $(window).on("load", function() {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // new DataTable('#rowBorder1');

            var table = $('#dt-table').DataTable({
                processing: true,
                serverSide: true,
                searching: true,

            });



        });


        {{--$(window).on("load", function() {--}}

        {{--    $.ajaxSetup({--}}
        {{--        headers: {--}}
        {{--            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')--}}
        {{--        }--}}
        {{--    });--}}

        {{--    // new DataTable('#rowBorder1');--}}

        {{--    var table = $('#dt-table').DataTable({--}}
        {{--        processing: true,--}}
        {{--        serverSide: true,--}}
        {{--        searching: true,--}}
        {{--        ajax: "{{ route('admin.hrm.employee.list') }}",--}}
        {{--        columns: [--}}
        {{--            {data: 'code', name: 'code'},--}}
        {{--            {data: 'name', name: 'name'},--}}
        {{--            {data: 'businessUnit', name: 'businessUnit'},--}}
        {{--            {data: 'departments_id', name: 'departments_id'},--}}
        {{--            {data: 'designations_id', name: 'designations_id'},--}}
        {{--            {data: 'phone', name: 'phone'},--}}
        {{--            {data: 'is_active', name: 'is_active'},--}}
        {{--            {data: 'action', name: 'action', orderable: false, searchable: false},--}}
        {{--        ],--}}

        {{--    });--}}



        {{--    $('#postForm').on('submit', function (e) {--}}
        {{--        e.preventDefault();--}}

        {{--        $.ajax({--}}
        {{--            url: "{{ route('admin.hrm.employee.saveEmployee') }}",--}}
        {{--            type: 'POST',--}}
        {{--            data: $(this).serialize(),--}}
        {{--            success: function (response) {--}}
        {{--                window.location.href = response.redirect;--}}
        {{--            },--}}
        {{--            error: function (response) {--}}
        {{--                // Handle validation errors--}}
        {{--                if(response.status === 422) {--}}
        {{--                    var errors = response.responseJSON.errors;--}}
        {{--                    $('.error').text(''); // Clear previous errors--}}
        {{--                    $.each(errors, function(key, value) {--}}
        {{--                        $('#' + key + 'Error').text(value[0]);--}}
        {{--                    });--}}
        {{--                }--}}
        {{--            }--}}
        {{--        });--}}
        {{--    });--}}

        {{--});--}}


    </script>
</x-admin-layout>
