<x-admin-layout>
    @section('title', 'Edit Employee')

    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16">Employee Details</h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('HR')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Employee List')}} </li>
            </ul>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">
            {{--Profile & Navigation--}}
            @include('admin.hrm.employeeNavigation')


            <div class="col-span-12 lg:col-span-9 xl:col-span-9 2xl:col-span-9">
                <div class="card">
                    <div class="card-body">
                        <h5 class="text-16 pb-5">Personal Information</h5>

                        <div id="message"></div>
                        <form id="postForm" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12">

                                <div class="xl:col-span-6">
                                    <x-input-field :value="old('first_name', $employee->first_name )"  :name="'first_name'" :label="__('First Name')" :mandatory="true" :disabled="false" />
                                </div><!--end col-->

                                <div class="xl:col-span-6">
                                    <x-input-field :value="old('last_name', $employee->last_name )"  :name="'last_name'" :label="__('Last Name')" :mandatory="true" :disabled="false" />
                                </div><!--end col-->

                                <div class="xl:col-span-6">
                                    <x-input-select :options="App\Models\Business\SetupBusinessUnit::where('is_active', 'Active')->get()" :value="old('business_unit',$employee->business_units_id  )" :name="'business_unit'" :label="__('Business Unit')" :mandatory="true" :disabled="false" />
                                </div><!--end col-->

                                <div class="xl:col-span-6">
                                    <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">Date of Birth</label>
                                    <span class="text-red-500">*</span>
                                    <input type="date" id="dateOdBirth" name="date_birth" class="form-control" value="{{$employee->date_birth}}">
                                    <p id="date_birthError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->

                                <div class="xl:col-span-6">
                                    <x-input-field :value="old('email', $employee->email )"  :name="'email'" :label="__('Email')" :mandatory="false" :disabled="false" />
                                </div><!--end col-->

                                <div class="xl:col-span-6">
                                    <x-input-field :value="old('phone', $employee->phone )"  :name="'phone'" :label="__('Phone')" :mandatory="true" :disabled="false" />
                                </div><!--end col-->

                                <div class="xl:col-span-6">
                                    <x-input-select :options="App\Models\SetupCountry::all()" :value="old('country', $employee->country_id )" :name="'country'" :label="__('Country')" :mandatory="true" :disabled="false" />
                                </div><!--end col-->
                                <div class="xl:col-span-6">
                                    <x-input-field :value="old('national_id', $employee->national_id )"  :name="'national_id'" :label="__('National Id')" :mandatory="false" :disabled="false" />
                                </div><!--end col-->
                                <div class="xl:col-span-6">
                                    <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Religious')}}</label>
                                    <span class="text-red-500">*</span>
                                    <select id="religious" name="religious" data-choices="" class="form-control">
                                        @foreach (config('options.religious') as $key => $value)
                                            <option value="{{$key}}" {{$employee->religious == $key ? 'selected':'' }} >{{$value}}</option>
                                        @endforeach
                                    </select>
                                    <p id="religiousError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->
                                <div class="xl:col-span-6">
                                    <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Marital Status')}}</label>
                                    <span class="text-red-500">*</span>
                                    <select id="marital_status" name="marital_status" data-choices="" class="form-control">
                                        @foreach (config('options.marital_status') as $key => $value)
                                            <option value="{{$key}}" {{$employee->marital_status == $key ? 'selected':'' }} >{{$value}}</option>
                                        @endforeach
                                    </select>
                                    <p id="marital_statusError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->
                                <div class="xl:col-span-6">
                                    <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Gender')}}</label>
                                    <span class="text-red-500">*</span>
                                    <select id="gender" name="gender" data-choices="" class="form-control">
                                        @foreach (config('options.gender') as $key => $value)
                                            <option value="{{$key}}" {{$employee->gender == $key ? 'selected':'' }} >{{$value}}</option>
                                        @endforeach
                                    </select>
                                    <p id="genderError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->
                                <div class="xl:col-span-6">
                                    <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Blood Group')}}</label>
                                    <span class="text-red-500">*</span>
                                    <select id="blood_group" name="blood_group" data-choices="" class="form-control">
                                        @foreach (config('options.blood_group') as $key => $value)
                                            <option value="{{$key}}" {{$employee->blood_group == $key ? 'selected':'' }} >{{$value}}</option>
                                        @endforeach
                                    </select>
                                    <p id="blood_groupError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->
                                <div class="xl:col-span-6">
                                    <label for="gender" class="inline-block mb-2 text-base font-medium">{{__('Employee Photo')}}</label>
                                    <input type="file" class="form-control" name="photo" >
                                    <p id="photoError" class="mt-1 text-sm text-red-500"></p>
                                </div><!--end col-->

                            </div><!--end grid-->

                            <div class="mt-4 text-right">
                                <button type="submit" class="text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20">Share Post</button>
                            </div>
                        </form>
                    </div>
                </div><!--end card-->
            </div>
        </div><!--end-->
    </div>

    <script type="text/javascript">

        $(window).on("load", function() {

            $('#postForm').on('submit', function (e) {
                e.preventDefault();
                var formData = new FormData(this);
                $.ajax({
                    url: "{{ route('admin.hrm.employee.updateEmployeeInfo',['id' => encrypt($employee->id)]) }}",
                    type: 'POST',
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        console.log(response.message)
                        if(response.success){
                            toastr.success(response.message);
                            var photoPath = "{{ asset('uploads/employee') }}/" + response.data.photo;
                            $('#empPhoto').attr('src', photoPath );
                            $('#empPhone').text(response.data.phone);
                            $('#empEmail').text(response.data.email);
                            $('#empName').text(response.data.first_name +' '+response.data.last_name);
                            console.log(response.data);
                        }else{
                            toastr.error(response.message);
                        }
                    },
                    error: function (response) {
                        // Handle validation errors
                        if(response.status === 422) {
                            var errors = response.responseJSON.errors;
                            $('.error').text(''); // Clear previous errors
                            $.each(errors, function(key, value) {
                                $('#' + key + 'Error').text(value[0]);
                            });
                        }
                    }
                });
            });

        });

    </script>

 </x-admin-layout>
