<x-admin-layout>
    @section('title', __('Inventory Item'))


    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">

        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16">{{__('Add Saleable Item')}}</h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">Products</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100">
                    {{__('Saleable Item')}}
                </li>
            </ul>
        </div>
        <form id="product-form" action="{{ route('admin.inventory.storeSaleableItem') }}" method="POST" enctype="multipart/form-data">
            @csrf

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

        <div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">

            <div class="xl:col-span-9">
                <div class="card">
                    <div class="card-body">
                        <h6 class="mb-4 text-15">Create Product</h6>
                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12">
                            <div class="xl:col-span-12">
                                <x-input-field value="{{ old('title', $product->title ?? '') }}"  name="title" :label="__('Title')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->

                            <div class="lg:col-span-2 xl:col-span-12">
                                <x-texteria-input value="{{ old('description', $product->description ?? '') }}"  :name="'description'" :label="__('Description')" :rows="5" :mandatory="false" :disabled="false" />
                            </div>

                        </div>

                        <x-select-inventory-category :column="3" :categoryPath="$categoryPath ?? []" />

                        <div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">

                            <div class="xl:col-span-4">
                                <x-number-input value="{{old('price', $product->sales_price ?? '')}}"  :name="'sales_price'" :label="__('Price')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->

                            <div class="xl:col-span-4">
                                <x-input-select :options="$taxes" value="{{old('taxes_id', $product->taxes_id ?? '')}}" :name="'taxes_id'" :label="__('Tax')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->

                            <div class="xl:col-span-4">
                                <x-input-select :options="$brands" value="{{old('brand_id', $product->brand_id ?? '')}}" :name="'brand_id'" :label="__('Brand')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->

                        </div><!--end grid-->


                    </div>

                </div><!--end card-->

                <div class="card">
                    <div class="card-body">
                        <h6 class="mb-4 text-15">{{__('Product Type')}}</h6>
                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12">

                            <div class="xl:col-span-6">
                                <div class="xl:col-span-6">
                                    @php
                                        $purchaseTypes = collect([
                                            (object)['id' => 'No', 'name' => __('No')],
                                            (object)['id' => 'Yes', 'name' => __('Yes')],
                                        ]);
                                    @endphp
                                    <x-input-select :options="$purchaseTypes" value="{{old('purchase_type', $product->purchase_type ?? '')}}" :name="'purchase_type'" :label="__('Item Purchasable ?')" :mandatory="true" :disabled="false" />
                                </div><!--end col-->
                            </div><!--end col-->

                            <div class="xl:col-span-6">
                                <x-input-field value="{{old('serial_no', $product->serial_no ?? '')}}"  :name="'serial_no'" :label="__('Serial No')" :mandatory="false" :disabled="false" />
                            </div><!--end col-->

                            <div class="xl:col-span-6">
                                <x-input-field value="{{old('lot_no', $product->lot_no ?? '')}}"  :name="'lot_no'" :label="__('Pat/Lot No')" :mandatory="false" :disabled="false" />
                            </div><!--end col-->

                            <div class="xl:col-span-6">
                                <x-input-field value="{{old('hscode', $product->hscode ?? '')}}"  :name="'hscode'" :label="__('HS Code')" :mandatory="false" :disabled="false" />
                            </div><!--end col-->

                        </div><!--end grid-->



                    </div>

                </div><!--end card-->

                <div class="card {{ isset($product->is_variant) && $product->is_variant == 0 ? 'hidden' : '' }}">

                <div class="card-body">
                        <h6 class="mb-4 text-15">Product Variant</h6>
                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12">
                            <div class="xl:col-span-12">
                                <span> <input type="checkbox" id="variantCheck" name="is_variant" {{ old('is_variant', $product->is_variant ?? '') ? 'checked' : '' }}> This product has options, like size or color</span>
                            </div><!--end col-->
                        </div><!--end grid-->
                        <br/>
                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12 {{$product->is_variant ?? '' ? '':'hidden'}}" id="option-area">
                            <div class="xl:col-span-3">
                                <input type="text" class="form-control" value="Options" readonly>
                            </div><!--end col-->
                            <div class="xl:col-span-9">
                                <select class="form-control" id="options" data-choices="" data-choices-removeitem=""
                                        name="options[]" multiple="">
                                    @foreach($attributes as $attribute)
                                        <option value="{{$attribute->id}}"
                                                @isset($productAttributes)
                                                    @if($productAttributes->contains('id', $attribute->id)) selected @endif
                                                @endisset>
                                            {{$attribute->name}}</option>
                                    @endforeach
                                </select>
                            </div><!--end col-->

                            <div class="xl:col-span-12">
                                <span>Choose the attributes of this product and then input values of each attribute</span>
                            </div><!--end col-->

                        </div><!--end grid-->




                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12 {{$product->is_variant ?? '' ? '':'hidden'}}" id="option-value-section">

                        </div><!--end grid-->


                        <div class="overflow-x-auto pt-2 {{$product->is_variant ?? '' ? '':'hidden'}}" id="variant-area">
                            <table class="w-full">
                                <thead class="ltr:text-left rtl:text-right ">
                                <tr>
                                    <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">
                                        Variant
                                    </th>

                                    <th class="px-3.5 py-2.5 font-semibold border border-slate-200 dark:border-zink-500">
                                        Price
                                    </th>
                                </tr>
                                </thead>
                                <tbody class="" id="combination-table">

                                </tbody>
                            </table>
                        </div>

                    </div>

                </div><!--end card-->


            </div><!--end col-->


            <div class="xl:col-span-3">
                <div class="card sticky top-[calc(theme('spacing.header')_*_1.3)]">
                    <div class="card-body">
                        {{--                        <h6 class="mb-4 text-15">Product Card Preview</h6>--}}

                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12" id="option-value-section">
                            <div class="xl:col-span-12">
                                @php
                                    $statusOptions = collect([
                                        (object)['id' => 'Published', 'name' => __('Published')],
                                        (object)['id' => 'Draft', 'name' => __('Draft')],
                                    ]);
                                @endphp
                                <x-input-select :options="$statusOptions" value="{{old('published', $product->published ?? 'Published')}}" :name="'published'" :label="__('Published')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->
                        </div><!--end grid-->

                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12" id="option-value-section">
                            <div class="xl:col-span-12">
                                <x-input-select :options="App\Models\Inventory\InventoryUnit::class::active()->get()" value="{{old('purchase_unit', $product->purchase_unit ?? '')}}" :name="'purchase_unit'" :label="__('Purchase UOM')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->
                        </div><!--end grid-->

                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12" id="option-value-section">
                            <div class="xl:col-span-12">
                                <x-number-input value="{{old('unit_conversion', $product->unit_conversion ?? '')}}"  :name="'unit_conversion'" :label="__('Conversion Factor')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->
                        </div><!--end grid-->

                        <div class="grid grid-cols-1 gap-5 lg:grid-cols-2 xl:grid-cols-12" id="option-value-section">
                            <div class="xl:col-span-12">
                                <x-input-select :options="App\Models\Inventory\InventoryUnit::class::active()->get()" value="{{old('sales_unit', $product->sales_unit ?? '')}}" :name="'sales_unit'" :label="__('Sales UOM')" :mandatory="true" :disabled="false" />
                            </div><!--end col-->
                        </div><!--end grid-->

                        <div class="px-5 py-8 rounded-md bg-sky-50 dark:bg-zink-600 text-center">
                            <input id="file-upload" type="file" name="item_img" class="hidden" />
{{--                            <img src="assets/images/img-03.png" alt="" class="block mx-auto h-44">--}}
                            <label for="file-upload" class="cursor-pointer">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                     fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                     data-lucide="upload-cloud"
                                     class="lucide lucide-upload-cloud block mx-auto size-12 text-slate-500 fill-slate-200 dark:text-zink-200 dark:fill-zink-500">
                                    <path d="M4 14.899A7 7 0 1 1 15.71 8h1.79a4.5 4.5 0 0 1 2.5 8.242"></path>
                                    <path d="M12 12v9"></path>
                                    <path d="m16 16-4-4-4 4"></path>
                                </svg>
                            </label>
                            <h5 id="file-name-label" class="mb-0 font-normal text-slate-500 text-15">Upload your Product Photo</h5>

                        </div>



                        <input type="hidden" name="id" value="{{$product->id ?? 'null'}}">

                        <div class="flex gap-2 mt-4">
                            <button type="submit"
                                    class="w-full bg-white border-dashed text-custom-500 btn border-custom-500 hover:text-custom-500 hover:bg-custom-50 hover:border-custom-600 focus:text-custom-600 focus:bg-custom-50 focus:border-custom-600 active:text-custom-600 active:bg-custom-50 active:border-custom-600 dark:bg-zink-700 dark:ring-custom-400/20 dark:hover:bg-custom-800/20 dark:focus:bg-custom-800/20 dark:active:bg-custom-800/20">
                                Save Item
                            </button>
{{--                            <button type="button"--}}
{{--                                    class="w-full text-white bg-purple-500 border-purple-500 btn hover:text-white hover:bg-purple-600 hover:border-purple-600 focus:text-white focus:bg-purple-600 focus:border-purple-600 focus:ring focus:ring-purple-100 active:text-white active:bg-purple-600 active:border-purple-600 active:ring active:ring-purple-100 dark:ring-purple-400/10">--}}
{{--                                Save Item--}}
{{--                            </button>--}}
                        </div>
                    </div>


                </div><!--end card-->


            </div><!--end col-->
        </div><!--end grid-->

        </form>

    </div>


    <script type="text/javascript">

        $(window).on("load", function () {

            let selectedOption = $('#options').val(); // Get selected values
            sendSelectedOption(selectedOption);

            $('#options').on('change', function () {
                let selectedValues = $(this).val(); // Get selected values
                sendSelectedOption(selectedValues);
            });

            function sendSelectedOption(selectedValues) {
                $.ajax({
                    url: "{{ route('admin.inventory.findAttributeValueByAttribute') }}",
                    type: 'POST',
                    data: {
                        selected: selectedValues,
                        inventory_item_id: {{ $product->id ?? 'null' }},
                        _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                    },
                    success: function (response) {
                        var itemsTable = $('#option-value-section');
                        itemsTable.empty();
                        itemsTable.html(response);

                        // Initialize Choices.js
                        itemsTable.find('select[data-choices]').each(function () {
                            new Choices(this, {
                                removeItemButton: true,
                            });
                        });
                        generateCombinations();
                    },
                    error: function (xhr) {
                        console.error('Error:', xhr.responseText);
                    },
                });
            }

        });


        function updatePricesFromSalesPrice() {
            let salesPrice = $('#sales_price').val();

            // Ensure it's a proper float with 2 decimals
            salesPrice = parseFloat(salesPrice);
            if (!isNaN(salesPrice) && salesPrice > 0) {
                $('input[name="prices[]"]').each(function () {
                    const currentVal = parseFloat($(this).val());
                    if (isNaN(currentVal) || currentVal <= 0) {
                        // Set the value properly
                        $(this).val(salesPrice.toFixed(2));
                    }
                });
            }
        }

        // 1. Initial run
        updatePricesFromSalesPrice();

        // 2. On sales_price change
        $('#sales_price').on('change', function () {
            updatePricesFromSalesPrice();
        });

        //---------------------------

        function generateCombinations() {
            @php
                $existingSkus = $existingSkus ?? [];
            @endphp
            let attributes = {};
            let existingSkus = @json($existingSkus);

            $('.combination-input').each(function () {
                const type = $(this).data('type'); // 'size', 'color', etc.
                const selected = $(this).find('option:selected');
                attributes[type] = [];

                selected.each(function () {
                    attributes[type].push({
                        label: $(this).text()
                    });
                });
            });

            console.log(attributes);

            // Only proceed if any attribute selected
            const typesSelected = Object.values(attributes).filter(arr => arr.length > 0);

            if (typesSelected.length === 0) {
                $('#combination-table').empty(); // clear if none selected
                return;
            }

            $.ajax({
                url: '{{ route('admin.inventory.generateCombinations') }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    attributes: attributes,
                    existingSkus: existingSkus,
                },
                success: function (response) {
                    $('#combination-table').html(response);
                    // Re-run the update logic for any new inputs
                    updatePricesFromSalesPrice();
                }
            });
        }

        // Run when user changes anything
        $(document).on('change', '.combination-input', function () {
            generateCombinations();
        });


    </script>

    <script>
        const fileInput = document.getElementById('file-upload');
        const label = document.getElementById('file-name-label');
        const form = document.getElementById('product-form');

        let fileIsValid = false;

        fileInput.addEventListener('change', function () {
            const file = fileInput.files[0];
            fileIsValid = false;  // reset on change

            if (file) {
                const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/svg+xml'];

                if (!validTypes.includes(file.type)) {
                    label.textContent = '⚠ Invalid file type';
                    label.classList.remove('text-slate-500');
                    label.classList.add('text-red-500');
                    alert('Please upload a valid image file (jpeg, png, gif, svg).');
                } else if (file.size > 2 * 1024 * 1024) {
                    label.textContent = '⚠ File too large (max 2MB)';
                    label.classList.remove('text-slate-500');
                    label.classList.add('text-red-500');
                    alert('File is too large. Maximum allowed size is 2MB.');
                } else {
                    label.textContent = file.name;
                    label.classList.remove('text-red-500');
                    label.classList.add('text-slate-500');
                    fileIsValid = true;
                }
            } else {
                label.textContent = 'Upload your Product Photo';
                label.classList.remove('text-red-500');
                label.classList.add('text-slate-500');
            }
        });

        form.addEventListener('submit', function(e) {
            if (!fileIsValid) {
                e.preventDefault();
                alert('Please select a valid image file before submitting.');
            }
        });
    </script>

    @push('scripts')

        <script>
            document.getElementById('variantCheck').addEventListener('change', function () {
                const optionArea = document.getElementById('option-area');
                const tableArea = document.getElementById('variant-area');
                const optionValueSection = document.getElementById('option-value-section');
                if (this.checked) {
                    optionArea.classList.remove('hidden');
                    tableArea.classList.remove('hidden');
                    optionValueSection.classList.remove('hidden');
                } else {
                    optionArea.classList.add('hidden');
                    tableArea.classList.add('hidden');
                    optionValueSection.classList.add('hidden');
                }
            });
        </script>





    @endpush


</x-admin-layout>
