<x-admin-layout>
    <script src="https://unpkg.com/preline/dist/preline.js"></script>
    <script>
        window.HSStaticMethods?.autoInit();
    </script>
    @section('title', __('Chart of Accounts'))
    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('Inventory')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Chart of Accounts')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('Chart of Accounts')}}</h6>

                <div class="grid grid-cols-1 gap-5 mb-5 xl:grid-cols-2">
                    <div>
                        <div class="relative xl:w-3/6">

                        </div>
                    </div>
{{--                    <div class="ltr:md:text-end rtl:md:text-start">--}}
{{--                        <button type="button"  class="btn-olive bg-green-500" onclick="openModal()">--}}
{{--                            <i class="align-bottom ri-add-line me-1"></i> {{__('Add Brand')}}--}}
{{--                        </button>--}}
{{--                    </div>--}}
                </div>
                <div class="pb-2">
                    @include('admin.validation')
                </div>




                <div id="tree-view" class="bg-white rounded-sm p-4" role="tree" aria-orientation="vertical" data-hs-tree-view="">
                    <!-- 1st Level Accordion -->
                    <div class="hs-accordion" role="treeitem" aria-expanded="false" id="hs-cco-tree-heading-one" data-hs-tree-view-item='{
    "value": "assets",
    "isDir": true
  }'>
                        <!-- 1st Level Accordion Heading -->
                        <div class="hs-accordion-heading py-0.5 rounded-md flex items-center gap-x-0.5 w-full hs-tree-view-selected:bg-gray-100 ">
                            <button class="hs-accordion-toggle size-6 flex justify-center items-center hover:bg-gray-100 rounded-md focus:outline-hidden focus:bg-gray-100 disabled:opacity-50 disabled:pointer-events-none " aria-expanded="false" aria-controls="hs-cco-tree-collapse-one">
                                <svg class="size-4 text-gray-800 dark:text-neutral-200" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M5 12h14"></path>
                                    <path class="hs-accordion-active:hidden block" d="M12 5v14"></path>
                                </svg>
                            </button>
                            <div class="grow hs-tree-view-selected:bg-gray-100  px-1.5 rounded-md cursor-pointer">
                                <div class="flex items-center gap-x-3">
                                    <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"></path>
                                    </svg>
                                    <div class="grow">


                                        <span class="text-sm text-gray-800 dark:text-neutral-200"> assets
                                         <a href="#!" data-modal-target="addEmployeeModal" class=" items-center justify-center transition-all duration-200 ease-linear rounded-md size-4 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500">
                                            +
                                        </a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End 1st Level Accordion Heading -->
                        <!-- 1st Level Collapse -->
                        <div id="hs-cco-tree-collapse-one" class="hs-accordion-content hidden w-full overflow-hidden transition-[height] duration-300" role="group" aria-labelledby="hs-cco-tree-heading-one">
                            <!-- 2nd Level Accordion Group -->
                            <div class="ps-7 relative before:absolute before:top-0 before:start-3 before:w-0.5 before:-ms-px before:h-full before:bg-gray-100 ">
                                <!-- 2nd Level Nested Accordion -->
                                <div class="hs-accordion active" role="treeitem" aria-expanded="true" id="hs-cco-tree-sub-heading-one" data-hs-tree-view-item='{
          "value": "css",
          "isDir": true
        }'>
                                    <!-- 2nd Level Accordion Heading -->
                                    <div class="hs-accordion-heading py-0.5 rounded-md flex items-center gap-x-0.5 w-full hs-tree-view-selected:bg-gray-100 ">
                                        <button class="hs-accordion-toggle size-6 flex justify-center items-center hover:bg-gray-100 rounded-md focus:outline-hidden focus:bg-gray-100 disabled:opacity-50 disabled:pointer-events-none " aria-expanded="true" aria-controls="hs-cco-tree-sub-collapse-one">
                                            <svg class="size-4 text-gray-800 dark:text-neutral-200" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M5 12h14"></path>
                                                <path class="hs-accordion-active:hidden block" d="M12 5v14"></path>
                                            </svg>
                                        </button>
                                        <div class="grow hs-tree-view-selected:bg-gray-100  px-1.5 rounded-md cursor-pointer">
                                            <div class="flex items-center gap-x-3">
                                                <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"></path>
                                                </svg>
                                                <div class="grow">


                                                        <div class="flex gap-3">
                                                            <span class="text-sm text-gray-800 dark:text-neutral-200"> css </span>

                                                            <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-4 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="plus" class="lucide lucide-plus inline-block mr-1 size-4"><path d="M5 12h14"></path><path d="M12 5v14"></path></svg>
                                                            </a>
                                                            <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-4 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="pencil" class="lucide lucide-pencil size-4"><path d="M17 3a2.85 2.83 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5Z"></path><path d="m15 5 4 4"></path></svg></a>

                                                            <a href="#!" class="flex items-center justify-center text-red-500 transition-all duration-200 ease-linear bg-red-100 rounded-md size-4 hover:text-white hover:bg-red-500 dark:bg-red-500/20 dark:hover:bg-red-500"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="trash-2" class="lucide lucide-trash-2 size-4"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path><line x1="10" x2="10" y1="11" y2="17"></line><line x1="14" x2="14" y1="11" y2="17"></line></svg></a>
                                                        </div>



                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End 2nd Level Accordion Heading -->
                                    <!-- 2nd Level Collapse -->
                                    <div id="hs-cco-tree-sub-collapse-one" class="hs-accordion-content w-full overflow-hidden transition-[height] duration-300" role="group" aria-labelledby="hs-cco-tree-sub-heading-one">
                                        <!-- 3rd Level Accordion Group -->
                                        <div class="ps-7 relative before:absolute before:top-0 before:start-3 before:w-0.5 before:-ms-px before:h-full before:bg-gray-100 ">
                                            <!-- 3rd Level Accordion -->
                                            <div class="hs-accordion active" role="treeitem" aria-expanded="true" id="hs-cco-tree-sub-level-two-heading-one" data-hs-tree-view-item='{
                "value": "main",
                "isDir": true
              }'>
                                                <!-- 3rd Level Accordion Heading -->
                                                <div class="hs-accordion-heading py-0.5 rounded-md flex items-center gap-x-0.5 w-full hs-tree-view-selected:bg-gray-100 ">
                                                    <button class="hs-accordion-toggle size-6 flex justify-center items-center hover:bg-gray-100 rounded-md focus:outline-hidden focus:bg-gray-100 disabled:opacity-50 disabled:pointer-events-none " aria-expanded="true" aria-controls="hs-cco-tree-sub-level-two-collapse-one">
                                                        <svg class="size-4 text-gray-800 dark:text-neutral-200" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                            <path d="M5 12h14"></path>
                                                            <path class="hs-accordion-active:hidden block" d="M12 5v14"></path>
                                                        </svg>
                                                    </button>
                                                    <div class="grow hs-tree-view-selected:bg-gray-100  px-1.5 rounded-md cursor-pointer">
                                                        <div class="flex items-center gap-x-3">
                                                            <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                                <path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"></path>
                                                            </svg>
                                                            <div class="grow">
                                                                <div class="flex gap-3">
                                                                    <span class="text-sm text-gray-800 dark:text-neutral-200"> main </span>

                                                                    <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-4 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="plus" class="lucide lucide-plus inline-block mr-1 size-4"><path d="M5 12h14"></path><path d="M12 5v14"></path></svg>
                                                                    </a>
                                                                    <a href="#!" data-modal-target="addEmployeeModal" class="flex items-center justify-center transition-all duration-200 ease-linear rounded-md size-4 edit-item-btn bg-slate-100 text-slate-500 hover:text-custom-500 hover:bg-custom-100 dark:bg-zink-600 dark:text-zink-200 dark:hover:bg-custom-500/20 dark:hover:text-custom-500"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="pencil" class="lucide lucide-pencil size-4"><path d="M17 3a2.85 2.83 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5Z"></path><path d="m15 5 4 4"></path></svg></a>

                                                                    <a href="#!" class="flex items-center justify-center text-red-500 transition-all duration-200 ease-linear bg-red-100 rounded-md size-4 hover:text-white hover:bg-red-500 dark:bg-red-500/20 dark:hover:bg-red-500"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" data-lucide="trash-2" class="lucide lucide-trash-2 size-4"><path d="M3 6h18"></path><path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"></path><path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"></path><line x1="10" x2="10" y1="11" y2="17"></line><line x1="14" x2="14" y1="11" y2="17"></line></svg></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- End 3rd Level Accordion Heading -->
                                                <!-- 3rd Level Collapse -->
                                                <div id="hs-cco-tree-sub-level-two-collapse-one" class="hs-accordion-content w-full overflow-hidden transition-[height] duration-300" role="group" aria-labelledby="hs-cco-tree-sub-level-two-heading-one">
                                                    <div class="ms-3 ps-3 relative before:absolute before:top-0 before:start-0 before:w-0.5 before:-ms-px before:h-full before:bg-gray-100 ">
                                                        <!-- 3rd Level Item -->
                                                        <div class="hs-tree-view-selected:bg-gray-100  px-2 rounded-md cursor-pointer" role="treeitem" data-hs-tree-view-item='{
                      "value": "main.css",
                      "isDir": false
                    }'>
                                                            <div class="flex items-center gap-x-3">
                                                                <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                                    <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path>
                                                                    <path d="M14 2v4a2 2 0 0 0 2 2h4"></path>
                                                                </svg>
                                                                <div class="grow">
                                                                    <span class="text-sm text-gray-800 dark:text-neutral-200"> main.css </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- End 3rd Level Item -->
                                                    </div>
                                                </div>
                                                <!-- End 3rd Level Collapse -->
                                            </div>
                                            <!-- End 3rd Level Accordion -->
                                            <!-- 3rd Level Accordion -->
                                            <div class="hs-accordion" role="treeitem" aria-expanded="false" id="hs-cco-tree-sub-level-two-heading-two" data-hs-tree-view-item='{
                "value": "tailwind",
                "isDir": true
              }'>
                                                <!-- 3rd Level Accordion Heading -->
                                                <div class="hs-accordion-heading py-0.5 rounded-md flex items-center gap-x-0.5 w-full hs-tree-view-selected:bg-gray-100 ">
                                                    <button class="hs-accordion-toggle size-6 flex justify-center items-center hover:bg-gray-100 rounded-md focus:outline-hidden focus:bg-gray-100 disabled:opacity-50 disabled:pointer-events-none " aria-expanded="false" aria-controls="hs-cco-tree-sub-level-two-collapse-two">
                                                        <svg class="size-4 text-gray-800 dark:text-neutral-200" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                            <path d="M5 12h14"></path>
                                                            <path class="hs-accordion-active:hidden block" d="M12 5v14"></path>
                                                        </svg>
                                                    </button>
                                                    <div class="grow hs-tree-view-selected:bg-gray-100  px-1.5 rounded-md cursor-pointer">
                                                        <div class="flex items-center gap-x-3">
                                                            <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                                <path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"></path>
                                                            </svg>
                                                            <div class="grow">
                                                                <span class="text-sm text-gray-800 dark:text-neutral-200"> tailwind </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- End 3rd Level Accordion Heading -->
                                                <!-- 3rd Level Collapse -->
                                                <div id="hs-cco-tree-sub-level-two-collapse-two" class="hs-accordion-content hidden w-full overflow-hidden transition-[height] duration-300" role="group" aria-labelledby="hs-cco-tree-sub-level-two-heading-two">
                                                    <div class="ms-3 ps-3 relative before:absolute before:top-0 before:start-0 before:w-0.5 before:-ms-px before:h-full before:bg-gray-100 ">
                                                        <!-- 3rd Level Item -->
                                                        <div class="hs-tree-view-selected:bg-gray-100  px-2 rounded-md cursor-pointer" role="treeitem" data-hs-tree-view-item='{
                      "value": "input.css",
                      "isDir": false
                    }'>
                                                            <div class="flex items-center gap-x-3">
                                                                <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                                    <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path>
                                                                    <path d="M14 2v4a2 2 0 0 0 2 2h4"></path>
                                                                </svg>
                                                                <div class="grow">
                                                                    <span class="text-sm text-gray-800 dark:text-neutral-200"> input.css </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- End 3rd Level Item -->
                                                    </div>
                                                </div>
                                                <!-- End 3rd Level Collapse -->
                                            </div>
                                            <!-- End 3rd Level Accordion -->
                                        </div>
                                        <!-- End 3rd Level Accordion Group -->
                                    </div>
                                    <!-- End 2nd Level Collapse -->
                                </div>
                                <!-- End 2nd Level Nested Accordion -->
                                <!-- 2nd Level Nested Accordion -->
                                <div class="hs-accordion" role="treeitem" aria-expanded="false" id="hs-cco-tree-sub-heading-two" data-hs-tree-view-item='{
          "value": "img",
          "isDir": true
        }'>
                                    <!-- 2nd Level Accordion Heading -->
                                    <div class="hs-accordion-heading py-0.5 rounded-md flex items-center gap-x-0.5 w-full hs-tree-view-selected:bg-gray-100 ">
                                        <button class="hs-accordion-toggle size-6 flex justify-center items-center hover:bg-gray-100 rounded-md focus:outline-hidden focus:bg-gray-100 disabled:opacity-50 disabled:pointer-events-none " aria-expanded="false" aria-controls="hs-cco-tree-sub-collapse-two">

                                            <!-- + icon (collapsed state) -->
                                            <svg class="hs-accordion-active:hidden block size-4 text-gray-800 dark:text-neutral-200"
                                                 xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                 stroke="currentColor" stroke-width="1.5">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16M4 12h16" />
                                            </svg>

                                            <!-- - icon (expanded state) -->
                                            <svg class="hs-accordion-active:block hidden size-4 text-gray-800 dark:text-neutral-200"
                                                 xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                 stroke="currentColor" stroke-width="1.5">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M4 12h16" />
                                            </svg>

                                        </button>
                                        <div class="grow hs-tree-view-selected:bg-gray-100  px-1.5 rounded-md cursor-pointer">
                                            <div class="flex items-center gap-x-3">
                                                <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"></path>
                                                </svg>
                                                <div class="grow">
                                                    <span class="text-sm text-gray-800 dark:text-neutral-200"> img </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End 2nd Level Accordion Heading -->
                                    <!-- 2nd Level Collapse -->
                                    <div id="hs-cco-tree-sub-collapse-two" class="hs-accordion-content hidden w-full overflow-hidden transition-[height] duration-300" role="group" aria-labelledby="hs-cco-tree-sub-heading-two">
                                        <div class="ms-3 ps-3 relative before:absolute before:top-0 before:start-0 before:w-0.5 before:-ms-px before:h-full before:bg-gray-100 ">
                                            <!-- 2nd Level Item -->
                                            <div class="hs-tree-view-selected:bg-gray-100  px-2 rounded-md cursor-pointer" role="treeitem" data-hs-tree-view-item='{
                "value": "hero.jpg",
                "isDir": false
              }'>
                                                <div class="flex items-center gap-x-3">
                                                    <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                        <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path>
                                                        <path d="M14 2v4a2 2 0 0 0 2 2h4"></path>
                                                        <circle cx="10" cy="12" r="2"></circle>
                                                        <path d="m20 17-1.296-1.296a2.41 2.41 0 0 0-3.408 0L9 22"></path>
                                                    </svg>
                                                    <div class="grow">
                                                        <span class="text-sm text-gray-800 dark:text-neutral-200"> hero.jpg </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- End 2nd Level Item -->
                                        </div>
                                    </div>
                                    <!-- End 2nd Level Collapse -->
                                </div>
                                <!-- End 2nd Level Nested Accordion -->
                            </div>
                            <!-- 2nd Level Accordion Group -->
                        </div>
                        <!-- End 1st Level Collapse -->
                    </div>
                    <!-- End 1st Level Accordion -->
                    <!-- 1st Level Accordion -->
                    <div class="hs-accordion" role="treeitem" aria-expanded="false" id="hs-cco-tree-heading-two" data-hs-tree-view-item='{
    "value": "scripts",
    "isDir": true
  }'>
                        <!-- 1st Level Accordion Heading -->
                        <div class="hs-accordion-heading py-0.5 rounded-md flex items-center gap-x-0.5 w-full hs-tree-view-selected:bg-gray-100 ">
                            <button class="hs-accordion-toggle size-6 flex justify-center items-center hover:bg-gray-100 rounded-md focus:outline-hidden focus:bg-gray-100 disabled:opacity-50 disabled:pointer-events-none " aria-expanded="false" aria-controls="hs-cco-tree-collapse-two">

                                <svg class="size-4 text-gray-800 dark:text-neutral-200" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M5 12h14"></path>
                                    <path class="hs-accordion-active:hidden block" d="M12 5v14"></path>
                                </svg>

                            </button>
                            <div class="grow hs-tree-view-selected:bg-gray-100  px-1.5 rounded-md cursor-pointer">
                                <div class="flex items-center gap-x-3">
                                    <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"></path>
                                    </svg>
                                    <div class="grow">
                                        <span class="text-sm text-gray-800 dark:text-neutral-200"> scripts </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End 1st Level Accordion Heading -->
                        <!-- 1st Level Collapse -->
                        <div id="hs-cco-tree-collapse-two" class="hs-accordion-content hidden w-full overflow-hidden transition-[height] duration-300" role="group" aria-labelledby="hs-cco-tree-heading-two">
                            <div class="ms-3 ps-3 relative before:absolute before:top-0 before:start-0 before:w-0.5 before:-ms-px before:h-full before:bg-gray-100 ">
                                <!-- 1st Level Item -->
                                <div class="hs-tree-view-selected:bg-gray-100  px-2 rounded-md cursor-pointer" role="treeitem" data-hs-tree-view-item='{
          "value": "preline.js",
          "isDir": false
        }'>
                                    <div class="flex items-center gap-x-3">
                                        <svg class="shrink-0 size-4 text-gray-500 dark:text-neutral-500" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path>
                                            <path d="M14 2v4a2 2 0 0 0 2 2h4"></path>
                                        </svg>
                                        <div class="grow">
                                            <span class="text-sm text-gray-800 dark:text-neutral-200"> preline.js </span>
                                        </div>
                                    </div>
                                </div>
                                <!-- End 1st Level Item -->
                            </div>
                        </div>
                        <!-- End 1st Level Collapse -->
                    </div>
                    <!-- End 1st Level Accordion -->
                </div>



            </div>





    </div>

    <!-- Modal Backdrop and Container -->
    <div id="modal" class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50 opacity-0 pointer-events-none transition-opacity duration-300">
        <!-- Modal Content -->
        <div class="w-screen md:w-[30rem] bg-white shadow rounded-md dark:bg-zink-600 transform scale-95 transition-all duration-300 ease-in-out">

            <!-- Modal Header -->
            <div class="flex items-center justify-between p-4 border-b border-slate-200 dark:border-zink-500">
                <h5 class="text-lg font-medium">{{ __('Brand') }}</h5>
                <button onclick="closeModal()" class="text-slate-400 hover:text-slate-500 transition">
                    <i data-lucide="x" class="size-5"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="max-h-[calc(100vh_-_180px)] overflow-y-auto p-4">
                <form class="tablelist-form" action="{{ route('admin.inventory.setup.brandStoreOrUpdate') }}" method="POST">
                    @csrf
                    <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12 pb-1">
                        <div class="xl:col-span-12">
                            <label for="name" class="inline-block mb-2 text-base font-medium"> {{__('Group')}}</label>
                            <span class="text-red-500">*</span>
                            <input type="text" name="name" id="edit-name" placeholder="Name" class="form-control" autocomplete="off">
                            <p id="nameError" class="mt-1 text-sm text-red-500 error"></p>
                        </div>

                        <div class="xl:col-span-12">
                            <label for="name" class="inline-block mb-2 text-base font-medium"> Status</label>
                            <select class="form-control" name="is_active" id="edit-status">
                                <option value="{{\App\Enums\GlobalEnum::ACTIVE}}" >{{\App\Enums\GlobalEnum::ACTIVE}}</option>
                                <option value="{{\App\Enums\GlobalEnum::IN_ACTIVE}}">{{\App\Enums\GlobalEnum::IN_ACTIVE}}</option>
                            </select>
                        </div>

                            <input type="hidden" name="id" id="edit-id">
                    </div>

                    <div class="flex justify-end gap-2 mt-4">
                        <button type="button" onclick="closeModal()" class="btn-grey bg-slate-500">Close</button>
                        <button type="submit" class="btn-olive bg-green-500">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>

        </div>
    </div>




    <script type="text/javascript">


        $(window).on("load", function() {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // new DataTable('#rowBorder1');

            {{--var table = $('#dt-table').DataTable({--}}
            {{--    processing: true,--}}
            {{--    serverSide: true,--}}
            {{--    searching: true,--}}
            {{--    ajax: "{{ route('admin.inventory.setup.brandList') }}",--}}
            {{--    columns: [--}}
            {{--        {data: 'code', name: 'code'},--}}
            {{--        {data: 'name', name: 'name'},--}}
            {{--        {data: 'is_active', name: 'is_active'},--}}
            {{--        {data: 'action', name: 'action', orderable: false, searchable: false},--}}

            {{--    ],--}}

            {{--});--}}

        });


    </script>

    <script>
        const modal = document.getElementById("modal");

        function openModal(id = null) {
            if (id) {
                fetch(`/admin/inventory/setup/editBrand/${id}`)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById("edit-id").value = data.id;
                        document.getElementById("edit-name").value = data.name;
                        document.getElementById("edit-status").value = data.is_active;
                    });
            }else{
                document.getElementById("edit-id").value = '';
                document.getElementById("edit-name").value = '';
            }
            modal.classList.remove("opacity-0", "pointer-events-none");
            modal.classList.add("opacity-100");
            setTimeout(() => {
                modal.querySelector("div").classList.add("scale-100");
                modal.querySelector("div").classList.remove("scale-95");
            }, 10);
        }

    </script>


    @push('scripts')

    @endpush


</x-admin-layout>
