<x-admin-layout>
    @section('title', __('Brand'))
    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('Inventory')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Brand')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('Brand List')}}</h6>

                <div class="grid grid-cols-1 gap-5 mb-5 xl:grid-cols-2">
                    <div>
                        <div class="relative xl:w-3/6">

                        </div>
                    </div>
                    <div class="ltr:md:text-end rtl:md:text-start">
                        <button type="button"  class="btn-olive bg-green-500" onclick="openModal()">
                            <i class="align-bottom ri-add-line me-1"></i> {{__('Add Brand')}}
                        </button>

                    </div>
                </div>
                <div class="pb-2">
                    @include('admin.validation')
                </div>
                <table id="dt-table" class="hover group" style="width:100%">
                    <thead>
                    <tr>
                        <th class="w-3/12">{{ __('Code') }}</th>
                        <th class="w-5/12">{{__('Group')}}</th>
                        <th class="w-3/12">{{__('Status')}}</th>
                        <th class="w-1/12" style="width: 50px">{{__('Action')}}</th>
                    </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200 dark:divide-zink-500">

                    </tbody>

                </table>
            </div>



    </div>

    <!-- Modal Backdrop and Container -->
    <div id="modal" class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50 opacity-0 pointer-events-none transition-opacity duration-300">
        <!-- Modal Content -->
        <div class="w-screen md:w-[30rem] bg-white shadow rounded-md dark:bg-zink-600 transform scale-95 transition-all duration-300 ease-in-out">

            <!-- Modal Header -->
            <div class="flex items-center justify-between p-4 border-b border-slate-200 dark:border-zink-500">
                <h5 class="text-lg font-medium">{{ __('Brand') }}</h5>
                <button onclick="closeModal()" class="text-slate-400 hover:text-slate-500 transition">
                    <i data-lucide="x" class="size-5"></i>
                </button>
            </div>

            <!-- Modal Body -->
            <div class="max-h-[calc(100vh_-_180px)] overflow-y-auto p-4">
                <form class="tablelist-form" action="{{ route('admin.inventory.setup.brandStoreOrUpdate') }}" method="POST">
                    @csrf
                    <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12 pb-1">
                        <div class="xl:col-span-12">
                            <label for="name" class="inline-block mb-2 text-base font-medium"> {{__('Group')}}</label>
                            <span class="text-red-500">*</span>
                            <input type="text" name="name" id="edit-name" placeholder="Name" class="form-control" autocomplete="off">
                            <p id="nameError" class="mt-1 text-sm text-red-500 error"></p>
                        </div>

                        <div class="xl:col-span-12">
                            <label for="name" class="inline-block mb-2 text-base font-medium"> Status</label>
                            <select class="form-control" name="is_active" id="edit-status">
                                <option value="{{\App\Enums\GlobalEnum::ACTIVE}}" >{{\App\Enums\GlobalEnum::ACTIVE}}</option>
                                <option value="{{\App\Enums\GlobalEnum::IN_ACTIVE}}">{{\App\Enums\GlobalEnum::IN_ACTIVE}}</option>
                            </select>
                        </div>

                            <input type="hidden" name="id" id="edit-id">
                    </div>

                    <div class="flex justify-end gap-2 mt-4">
                        <button type="button" onclick="closeModal()" class="btn-grey bg-slate-500">Close</button>
                        <button type="submit" class="btn-olive bg-green-500">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>

        </div>
    </div>




    <script type="text/javascript">


        $(window).on("load", function() {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // new DataTable('#rowBorder1');

            var table = $('#dt-table').DataTable({
                processing: true,
                serverSide: true,
                searching: true,
                ajax: "{{ route('admin.inventory.setup.brandList') }}",
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'name', name: 'name'},
                    {data: 'is_active', name: 'is_active'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},

                ],

            });

        });


    </script>

    <script>
        const modal = document.getElementById("modal");

        function openModal(id = null) {
            if (id) {
                fetch(`/admin/inventory/setup/editBrand/${id}`)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById("edit-id").value = data.id;
                        document.getElementById("edit-name").value = data.name;
                        document.getElementById("edit-status").value = data.is_active;
                    });
            }else{
                document.getElementById("edit-id").value = '';
                document.getElementById("edit-name").value = '';
            }
            modal.classList.remove("opacity-0", "pointer-events-none");
            modal.classList.add("opacity-100");
            setTimeout(() => {
                modal.querySelector("div").classList.add("scale-100");
                modal.querySelector("div").classList.remove("scale-95");
            }, 10);
        }

    </script>


    @push('scripts')

    @endpush


</x-admin-layout>
