<x-admin-layout>
    @section('title', 'User Roll')

    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('Create Roll')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Create Roll')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('Create Roll')}}</h6>
                <div class="grid grid-cols-1 gap-5 mb-5 xl:grid-cols-2">
                    <div>
                        <div class="relative xl:w-3/6">

                        </div>
                    </div>

                </div>

                {{--                @include('admin.layouts.partials.validation')--}}
                <form action="{{route('admin.roles.store')}}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label class="form-label" for="cf-full-name">Role Name</label>
                        <input type="text" name="name" class="form-control" placeholder="Enter a Role Name">
                    </div>

                    <div class="mt-4 mb-4">
                        <strong><label for="name" class="">Permissions</label></strong>
                    </div>


                    <div class="form-check mb-4" style="padding-left: 15px">
                        <input type="checkbox" class="form-check-input form-check-input w-5 h-5 text-blue-500 border-gray-300 rounded focus:ring-blue-400" id="checkPermissionAll" value="1">
                        <label class="form-check-label" for="checkPermissionAll">All</label>
                    </div>

                    <hr>


                    @php $i = 1; @endphp
                    @foreach ($permission_groups as $group)
                    <div class="w-full mx-auto p-4">
                        <div class="grid grid-cols-12 items-start gap-4">
                            <!-- Group Name (More Space & Aligned to Top Left) -->

                            <label class="col-span-4 flex items-start space-x-2 text-left">
                                <input type="checkbox" class="form-check-input w-5 h-5 text-blue-500 border-gray-300 rounded focus:ring-blue-400" id="{{ $i }}Management" value="{{ $group->name }}" onclick="checkPermissionByGroup('role-{{ $i }}-management-checkbox', this)">
                                <label class="font-semibold" for="checkPermission">{{ $group->name }}</label>

                            </label>

                            <!-- Sub-checkboxes (9 Columns) -->
                            <div class="col-span-8 grid grid-cols-2 gap-x-6 gap-y-2 role-{{ $i }}-management-checkbox">
                                @php
                                    $permissions = App\Models\Admin::getpermissionsByGroupName($group->name);
                                    $j = 1;
                                @endphp
                                @foreach ($permissions as $permission)
                                <label class="flex items-center space-x-2 form-check">
                                    <input type="checkbox" class="blog-checkbox w-4 h-4 text-blue-500 border-gray-300 rounded focus:ring-blue-400" name="permissions[]" id="checkPermission{{ $permission->id }}" value="{{ $permission->name }}">
                                    <span class="form-check-label" for="checkPermission{{ $permission->id }}">{{ $permission->name }}</span>

                                </label>
                                    @php  $j++; @endphp
                                @endforeach
                            </div>
                        </div>
                    </div>
                     @php  $i++; @endphp
                    @endforeach

                    <div class="mt-4 text-left">
                        <button type="submit"  class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" >
                            {{__('Create New Roll')}}
                        </button>
                    </div>
                </form>

            </div>
        </div><!--end card-->

    </div>


        <script>
            /**
             * Check all the permissions
             */
            $("#checkPermissionAll").click(function(){
                if($(this).is(':checked')){
                    // check all the checkbox
                    $('input[type=checkbox]').prop('checked', true);
                }else{
                    // un check all the checkbox
                    $('input[type=checkbox]').prop('checked', false);
                }
            });
            function checkPermissionByGroup(className, checkThis){
                const groupIdName = $("#"+checkThis.id);
                const classCheckBox = $('.'+className+' input');
                if(groupIdName.is(':checked')){
                    classCheckBox.prop('checked', true);
                }else{
                    classCheckBox.prop('checked', false);
                }
            }
        </script>

</x-admin-layout>

