<x-admin-layout>
    @section('title', 'User Roll List')


    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('User')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('Roll')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('User Roll')}}</h6>
                <div class="grid grid-cols-1 gap-5 mb-5 xl:grid-cols-2">
                    <div>
                        <div class="relative xl:w-3/6">

                        </div>
                    </div>
                    <div class="ltr:md:text-end rtl:md:text-start">
                        <a type="button" href="{{'/admin/roles/create'}}" class="bg-custom-500 btn-primary "  id="create-btn" ><i class="align-bottom ri-add-line me-1"></i> {{__('Create Roll')}}</a>

                    </div>
                </div>


                <div class="-mx-5 overflow-x-auto">
                    <table class="w-full whitespace-nowrap">
                        <thead class="ltr:text-left rtl:text-right">
                        <tr class="bg-slate-100 dark:bg-zink-600">
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">Sl</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">Name</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 text-right">Action</th>
                        </tr>
                        </thead>
                        <tbody class="list">

                        @foreach($roles as $role)
                        <tr>
                            <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">{{$loop->index + 1}}</td>
                            <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">{{$role->name}}</td>
                            <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 text-right">
                                <div class="flex gap-3 justify-end">
{{--                                    <a class="anchor-button" href="pages-account.html">--}}
{{--                                        <i data-lucide="eye" class="inline-block size-3"></i>--}}
{{--                                    </a>--}}
                                    <a href="{{route('admin.roles.edit', $role->id)}}" class="anchor-button">
                                        <i data-lucide="pencil" class="size-4"></i>
                                    </a>
                                    <a href="{{ route('admin.roles.destroy', $role->id) }}"
                                       onclick="event.preventDefault(); document.getElementById('delete-form-{{ $role->id }}').submit();" class="anchor-button">
                                        <i data-lucide="trash-2" class="size-4"></i>
                                    </a>
                                    <form id="delete-form-{{ $role->id }}" action="{{ route('admin.roles.destroy', $role->id) }}" method="POST" style="display: none;">
                                        @method('DELETE')
                                        @csrf
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        </div><!--end card-->

    </div>

</x-admin-layout>
