<x-admin-layout>
    @section('title', 'Create User')

        <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
            <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
                <div class="grow">
                    <h5 class="text-16"></h5>
                </div>
                <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                    <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                        <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('User')}}</a>
                    </li>
                    <li class="text-slate-700 dark:text-zink-100"> {{__('Create User')}} </li>
                </ul>
            </div>

            <div class="card">
                <div class="card-body">
                    <h5 class="text-16 pb-5">{{__('Employee Login')}}</h5>
                    <hr class="pb-5"/>
                    <div id="message"></div>

                    <form action="{{ route('admin.admins.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-12">

                            <div class="xl:col-span-7">
                                <x-input-field :value="old('name' )"  :name="'name'" :label="__('Name')" :mandatory="true" :disabled="false" />
                                @error('name')<div class="mt-1 text-sm text-red-500 error">{{ $message }}</div>@enderror
                            </div><!--end col-->

                            <div class="xl:col-span-7">
                                <x-input-field :value="old('email' )"  :name="'email'" :label="__('Email')" :mandatory="true" :disabled="false" />
                                @error('email')<div class="mt-1 text-sm text-red-500 error">{{ $message }}</div>@enderror
                            </div><!--end col-->

                            <div class="xl:col-span-7">
                                <x-password-field :value="old('password')"  :name="'password'" :label="__('Password')" :mandatory="true" :disabled="false" />
                                @error('password')<div class="mt-1 text-sm text-red-500 error">{{ $message }}</div>@enderror
                            </div><!--end col-->
                            <div class="xl:col-span-7">
                                <x-password-field :value="old('password_confirmation')"  :name="'password_confirmation'" :label="__('Confirm Password')" :mandatory="true" :disabled="false" />
                                @error('password_confirmation')<div class="mt-1 text-sm text-red-500 error">{{ $message }}</div>@enderror
                            </div><!--end col-->

                            <div class="xl:col-span-7">
                                <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">{{__('Staff Role')}}</label>
                                <span class="text-red-500">*</span>
                                <select class="form-control" data-choices="" data-choices-removeitem="" name="selectedRole[]" multiple="">
                                    @foreach(Spatie\Permission\Models\Role::get() as $role)
                                        <option value="{{ $role->name }}" @if(!empty($employeeLogin)){{ $employeeLogin->hasRole($role->name) ? 'selected' : '' }} @endif>{{ $role->name }}</option>
                                    @endforeach
                                </select>
                                <p id="selectedRoleError" class="mt-1 text-sm text-red-500 error"></p>
                            </div><!--end col-->

                            <div class="xl:col-span-7">
                                <label for="zipcodeInput" class="inline-block mb-2 text-base font-medium">{{__('Profile Picture')}}</label>
                                <input type="file" class="form-control" id="profile_picture" name="profile_picture" >
                            </div>



                        </div><!--end grid-->

                        <div class="mt-4 text-left">
                            <button type="submit"  class="bg-custom-500 btn-primary " data-bs-toggle="modal" id="create-btn" >
                                {{__('Save')}}
                            </button>
                        </div>
                    </form>

                </div>
            </div><!--end card-->

        </div>


        <script>

            $(function() {
                $('.select2').select2();
            })
        </script>

</x-admin-layout>

