<x-admin-layout>
    @section('title', 'User List')

    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16"></h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                    <a href="#!" class="text-slate-400 dark:text-zink-200">{{__('User')}}</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100"> {{__('User List')}} </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="mb-4 text-15">{{__('User List')}}</h6>
                <div class="grid grid-cols-1 gap-5 mb-5 xl:grid-cols-2">
                    <div>
                        <div class="relative xl:w-3/6">

                        </div>
                    </div>
                    <div class="ltr:md:text-end rtl:md:text-start">
                        <a type="button" href="{{route('admin.admins.create')}}" class="bg-custom-500 btn-primary "  id="create-btn" ><i class="align-bottom ri-add-line me-1"></i> {{__('Add New User')}}</a>

                    </div>
                </div>


                <div class="hover group" style="width:100%">
                    <table id="dt-table" class="w-full whitespace-nowrap">
                        <thead class="ltr:text-left rtl:text-right">
                        <tr class="bg-slate-100 dark:bg-zink-600">
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">{{__('Sl')}}</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">{{__('Name')}}</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">{{__('Email')}}</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">{{__('Department')}}</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">{{__('Rolls')}}</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500">{{__('User Type')}}</th>
                            <th class="px-3.5 py-2.5 first:pl-5 last:pr-5 font-semibold border-b border-slate-200 dark:border-zink-500 text-right">{{__('Action')}}</th>
                        </tr>
                        </thead>
                        <tbody class="list">

                        @foreach($admins as $admin)
                            <tr>
                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">{{$loop->index + 1}}</td>
                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">{{$admin->name}}</td>
                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">{{$admin->email}}</td>
                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">

                                </td>
                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">
                                    @foreach ($admin->roles as $role)
                                        <span class="label-primary">
                                            {{ $role->name }}
                                        </span>

                                    @endforeach
                                </td>
                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500">{{$admin->user_type}}</td>

                                <td class="px-3.5 py-2.5 first:pl-5 last:pr-5 border-y border-slate-200 dark:border-zink-500 text-right">
                                    <div class="flex gap-3 justify-end">
                                        <a href="{{route('admin.admins.edit', $admin->id)}}" class="anchor-button">
                                            <i data-lucide="pencil" class="size-4"></i>
                                        </a>
                                        <a href="{{ route('admin.admins.destroy', $admin->id) }}"
                                           onclick="event.preventDefault(); document.getElementById('delete-form-{{ $admin->id }}').submit();">
                                            <i data-lucide="trash-2" class="size-4"></i>
                                        </a>
                                        <form id="delete-form-{{ $admin->id }}" action="{{ route('admin.admins.destroy', $admin->id) }}" method="POST" style="display: none;">
                                            @method('DELETE')
                                            @csrf
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        </div><!--end card-->

    </div>

    <script>
        $(window).on("load", function() {
            $('#dt-table').DataTable({

            })
        });



    </script>

</x-admin-layout>

